/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.formatter;

import workbench.resource.GeneratedIdentifierCase;
import workbench.resource.Settings;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class FormatterUtil {
    public static String getIdentifier(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        if (SqlUtil.isQuotedIdentifier(string)) {
            return string;
        }
        if (string.indexOf(34) > -1) {
            return string;
        }
        if (string.indexOf(91) > -1) {
            return string;
        }
        return FormatterUtil.adjustCase(string, Settings.getInstance().getFormatterIdentifierCase());
    }

    public static String getFunction(String string) {
        return FormatterUtil.adjustCase(string, Settings.getInstance().getFormatterIdentifierCase());
    }

    public static String getKeyword(String string) {
        return FormatterUtil.adjustCase(string, Settings.getInstance().getFormatterKeywordsCase());
    }

    public static String getDataType(String string) {
        return FormatterUtil.adjustCase(string, Settings.getInstance().getFormatterDatatypeCase());
    }

    private static String adjustCase(String string, GeneratedIdentifierCase generatedIdentifierCase) {
        if (string == null) {
            return null;
        }
        switch (generatedIdentifierCase) {
            case lower: {
                return string.toLowerCase();
            }
            case upper: {
                return string.toUpperCase();
            }
        }
        return string;
    }
}

