/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.QuoteHandler;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.ConstantColumnValues;
import workbench.sql.DelimiterDefinition;
import workbench.sql.generator.InsertGenerator;
import workbench.sql.generator.InsertType;
import workbench.storage.ColumnData;
import workbench.storage.RowData;
import workbench.storage.SqlLiteralFormatter;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;

public class DefaultInsertGenerator
implements InsertGenerator {
    private final TableIdentifier table;
    protected final List<ColumnIdentifier> targetColumns;
    private List<ColumnIdentifier> keyColumns;
    private InsertType type;
    private String insertSqlStart;
    private ConstantColumnValues columnConstants;
    protected final QuoteHandler quoteHandler;
    protected VersionNumber dbVersion;
    private final List<RowData> rows = new ArrayList<RowData>();
    private String delimiter = ";";
    private WbConnection dbConnection;

    public DefaultInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        this(tableIdentifier, list, null);
    }

    public DefaultInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, WbConnection wbConnection) {
        this.table = tableIdentifier;
        this.targetColumns = new ArrayList<ColumnIdentifier>(list);
        this.type = InsertType.Insert;
        this.dbConnection = wbConnection;
        if (wbConnection == null) {
            this.quoteHandler = QuoteHandler.STANDARD_HANDLER;
            this.dbVersion = new VersionNumber(0, 0);
        } else {
            this.quoteHandler = wbConnection.getMetadata();
            this.dbVersion = wbConnection.getDatabaseVersion();
        }
    }

    @Override
    public void setColumnConstants(ConstantColumnValues constantColumnValues) {
        this.columnConstants = constantColumnValues;
    }

    @Override
    public void setDelimiter(DelimiterDefinition delimiterDefinition) {
        this.delimiter = delimiterDefinition.isSingleLine() ? delimiterDefinition.getDelimiter() : delimiterDefinition.getDelimiter() + '\n';
    }

    @Override
    public List<ColumnIdentifier> getKeyColumns() {
        if (CollectionUtil.isEmpty(this.keyColumns)) {
            return this.getPKColumns();
        }
        return this.keyColumns;
    }

    @Override
    public void setKeyColumns(List<ColumnIdentifier> list) {
        this.keyColumns = new ArrayList<ColumnIdentifier>(1);
        if (list == null) {
            return;
        }
        for (ColumnIdentifier columnIdentifier : list) {
            this.keyColumns.add(columnIdentifier.createCopy());
        }
    }

    @Override
    public void setInsertStartSQL(String string) {
        this.insertSqlStart = string;
    }

    @Override
    public String createLiteralSQL(SqlLiteralFormatter sqlLiteralFormatter) {
        return this.createLiteralSQL(this.rows, sqlLiteralFormatter);
    }

    @Override
    public String createLiteralSQL(List<RowData> list, SqlLiteralFormatter sqlLiteralFormatter) {
        switch (this.type) {
            case Insert: 
            case InsertIgnore: 
            case Upsert: {
                return this.createInsertWithLiterals(list, sqlLiteralFormatter);
            }
        }
        return null;
    }

    protected String createInsertWithLiterals(List<RowData> list, SqlLiteralFormatter sqlLiteralFormatter) {
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 50 + this.targetColumns.size() * list.size() * 15 + 50);
        if (this.supportsMultiRowInserts()) {
            stringBuilder.append(this.buildInsertPart());
            stringBuilder.append(this.buildValuesList(list, sqlLiteralFormatter));
            stringBuilder.append(this.buildFinalPart());
        } else {
            boolean bl = list.size() > 1;
            for (RowData rowData : list) {
                stringBuilder.append(this.buildInsertPart());
                stringBuilder.append(this.buildValuesList(Collections.singletonList(rowData), sqlLiteralFormatter));
                stringBuilder.append(this.buildFinalPart());
                if (!bl) continue;
                stringBuilder.append(this.delimiter);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String createPreparedSQL(int n) {
        switch (this.type) {
            case Insert: 
            case InsertIgnore: 
            case Upsert: {
                return this.createInsertPrepared(n);
            }
        }
        return null;
    }

    protected String createInsertPrepared(int n) {
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 50 + this.targetColumns.size() * n * 5 + 50);
        if (this.supportsMultiRowInserts()) {
            stringBuilder.append(this.buildInsertPart());
            stringBuilder.append(this.buildParameterList(n));
            stringBuilder.append(this.buildFinalPart());
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.buildInsertPart());
                stringBuilder.append(this.buildParameterList(1));
                stringBuilder.append(this.buildFinalPart());
                if (n <= 1) continue;
                stringBuilder.append(";\n");
            }
        }
        return stringBuilder.toString();
    }

    protected String getInsertSQLStart() {
        return this.insertSqlStart;
    }

    protected CharSequence buildInsertPart() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 50);
        String string = this.getInsertSQLStart();
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        } else {
            stringBuilder.append("INSERT INTO ");
        }
        stringBuilder.append(this.getTargetTableName());
        stringBuilder.append("\n  (");
        for (n = 0; n < this.targetColumns.size(); ++n) {
            ColumnIdentifier columnIdentifier = this.targetColumns.get(n);
            if (n > 0) {
                stringBuilder.append(',');
            }
            String string2 = columnIdentifier.getDisplayName();
            string2 = this.quoteHandler.quoteObjectname(string2);
            stringBuilder.append(string2);
        }
        if (this.columnConstants != null) {
            n = this.columnConstants.getColumnCount();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(',');
                stringBuilder.append(this.columnConstants.getColumn(i).getColumnName());
            }
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    protected CharSequence buildParameterList(int n) {
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 5 + n);
        stringBuilder.append("\nVALUES\n  ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(",\n  ");
            }
            stringBuilder.append('(');
            for (int j = 0; j < this.targetColumns.size(); ++j) {
                if (j > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('?');
            }
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    protected CharSequence createValuesStart() {
        return "\nVALUES\n  ";
    }

    protected CharSequence buildValuesList(List<RowData> list, SqlLiteralFormatter sqlLiteralFormatter) {
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 5 + list.size());
        stringBuilder.append(this.createValuesStart());
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",\n  ");
            }
            RowData rowData = list.get(i);
            stringBuilder.append('(');
            for (int j = 0; j < this.targetColumns.size(); ++j) {
                if (j > 0) {
                    stringBuilder.append(',');
                }
                ColumnData columnData = new ColumnData(rowData.getValue(j), this.targetColumns.get(j));
                CharSequence charSequence = sqlLiteralFormatter.getDefaultLiteral(columnData);
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    protected String buildRowValues() {
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 50);
        return stringBuilder.toString();
    }

    protected CharSequence buildFinalPart() {
        return "";
    }

    protected String getColumnConstant(ColumnIdentifier columnIdentifier) {
        if (this.columnConstants == null) {
            return null;
        }
        return null;
    }

    public String getTargetTableName() {
        return this.table.getFullyQualifiedName(this.dbConnection);
    }

    @Override
    public TableIdentifier getTargetTable() {
        return this.table;
    }

    @Override
    public boolean supportsType(InsertType insertType) {
        return insertType == InsertType.Insert;
    }

    @Override
    public InsertType getInsertType() {
        return this.type;
    }

    @Override
    public void setInsertType(InsertType insertType) {
        if (!this.supportsType(insertType)) {
            throw new IllegalArgumentException("Insert type " + (Object)((Object)insertType) + " not supported!");
        }
        if (this.type != insertType) {
            this.type = insertType;
            this.buildInsertPart();
        }
    }

    @Override
    public boolean supportsMultiRowInserts() {
        return true;
    }

    @Override
    public int addRow(RowData rowData) {
        this.rows.add(rowData);
        return this.rows.size();
    }

    @Override
    public List<RowData> getValues() {
        return Collections.unmodifiableList(this.rows);
    }

    @Override
    public void clearRowData() {
        this.rows.clear();
    }

    @Override
    public List<ColumnIdentifier> getPKColumns() {
        if (this.targetColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(1);
        for (ColumnIdentifier columnIdentifier : this.targetColumns) {
            if (!columnIdentifier.isPkColumn()) continue;
            arrayList.add(columnIdentifier);
        }
        return arrayList;
    }
}

