/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.generator;

import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.sql.generator.DefaultInsertGenerator;
import workbench.sql.generator.InsertType;

public class OracleInsertGenerator
extends DefaultInsertGenerator {
    public OracleInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        super(tableIdentifier, list);
    }

    public OracleInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, WbConnection wbConnection) {
        super(tableIdentifier, list, wbConnection);
    }

    @Override
    public boolean supportsMultiRowInserts() {
        return false;
    }

    @Override
    public boolean supportsType(InsertType insertType) {
        return super.supportsType(insertType) || insertType == InsertType.InsertIgnore || insertType == InsertType.Merge;
    }

    @Override
    protected String getInsertSQLStart() {
        if (this.getInsertType() == InsertType.InsertIgnore) {
            String string = "INSERT /*+ IGNORE_ROW_ON_DUPKEY_INDEX (";
            string = string + this.getTargetTableName() + "(";
            List<ColumnIdentifier> list = this.getKeyColumns();
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                String string2 = list.get(i).getDisplayName();
                string = string + string2;
            }
            string = string + ")) */ INTO ";
            return string;
        }
        return super.getInsertSQLStart();
    }
}

