/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.macros;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.KeyStroke;
import workbench.interfaces.MacroChangeListener;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.resource.StoreableKeyStroke;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.MacroStorage;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.WbFile;

public class MacroManager {
    public static final int DEFAULT_STORAGE = Integer.MIN_VALUE;
    private final Map<String, MacroStorage> allMacros = new HashMap<String, MacroStorage>();
    private final Map<Integer, String> macroClients = new HashMap<Integer, String>();

    private MacroManager() {
        WbFile wbFile = MacroManager.getDefaultMacroFile();
        long l = System.currentTimeMillis();
        MacroStorage macroStorage = new MacroStorage(wbFile);
        long l2 = System.currentTimeMillis() - l;
        this.allMacros.put(wbFile.getFullPath(), macroStorage);
        LogMgr.logDebug(new CallerInfo(){}, "Loading default macros took " + l2 + "ms");
        this.dumpMacroInfo();
    }

    public static MacroManager getInstance() {
        return InstanceHolder.instance;
    }

    public static WbFile getDefaultMacroFile() {
        return new WbFile(Settings.getInstance().getMacroStorage());
    }

    public synchronized void save() {
        for (MacroStorage macroStorage : this.allMacros.values()) {
            macroStorage.saveMacros();
        }
    }

    public void saveAs(int n, WbFile wbFile) {
        MacroStorage macroStorage = this.allMacros.get(this.getClientfilename(n));
        if (macroStorage != null) {
            macroStorage.saveMacros(wbFile);
            this.macroClients.put(n, wbFile.getFullPath());
        }
    }

    public void save(int n) {
        String string = this.getClientfilename(n);
        MacroStorage macroStorage = this.allMacros.get(string);
        if (macroStorage != null && macroStorage.isModified()) {
            macroStorage.saveMacros(new WbFile(string));
        }
    }

    private String getClientfilename(int n) {
        String string = this.macroClients.get(n);
        if (string == null) {
            return MacroManager.getDefaultMacroFile().getFullPath();
        }
        return string;
    }

    public void loadDefaultMacros(int n) {
        this.loadMacros(n, MacroManager.getDefaultMacroFile());
    }

    public synchronized void loadMacros(int n, WbFile wbFile) {
        String string = wbFile.getFullPath();
        String string2 = this.macroClients.get(n);
        MacroStorage macroStorage = null;
        if (string2 != null) {
            macroStorage = this.allMacros.get(string2);
        }
        if (macroStorage == null) {
            macroStorage = new MacroStorage(wbFile);
        } else {
            if (this.isNonDefaultMacroFile(string2)) {
                this.allMacros.remove(string2);
            }
            macroStorage.loadNewFile(wbFile);
        }
        LogMgr.logDebug(new CallerInfo(){}, "Loaded " + macroStorage.getSize() + " macros from file " + wbFile.getFullPath() + " for clientId:  " + n);
        this.allMacros.put(string, macroStorage);
        this.macroClients.put(n, string);
        this.dumpMacroInfo();
    }

    private boolean isNonDefaultMacroFile(String string) {
        WbFile wbFile = new WbFile(string);
        return !wbFile.equals(MacroManager.getDefaultMacroFile());
    }

    private MacroStorage getStorage(int n) {
        String string = this.getClientfilename(n);
        MacroStorage macroStorage = this.allMacros.get(string);
        if (macroStorage == null) {
            macroStorage = this.allMacros.get(MacroManager.getDefaultMacroFile().getFullPath());
        }
        return macroStorage;
    }

    public synchronized String getMacroText(int n, String string) {
        if (string == null) {
            return null;
        }
        MacroStorage macroStorage = this.getStorage(n);
        if (macroStorage == null) {
            return null;
        }
        MacroDefinition macroDefinition = macroStorage.getMacro(string);
        if (macroDefinition == null) {
            return null;
        }
        return macroDefinition.getText();
    }

    public void addChangeListener(MacroChangeListener macroChangeListener, int n) {
        MacroStorage macroStorage = this.getMacros(n);
        if (macroStorage != null) {
            macroStorage.addChangeListener(macroChangeListener);
        }
    }

    public void removeChangeListener(MacroChangeListener macroChangeListener, int n) {
        MacroStorage macroStorage = this.getMacros(n);
        if (macroStorage != null) {
            macroStorage.removeChangeListener(macroChangeListener);
        }
    }

    public synchronized MacroStorage getMacros(int n) {
        return this.getStorage(n);
    }

    public synchronized MacroDefinition getMacroForKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return null;
        }
        for (MacroStorage macroStorage : this.allMacros.values()) {
            StoreableKeyStroke storeableKeyStroke = new StoreableKeyStroke(keyStroke);
            List<MacroGroup> list = macroStorage.getGroups();
            for (MacroGroup macroGroup : list) {
                for (MacroDefinition macroDefinition : macroGroup.getMacros()) {
                    StoreableKeyStroke storeableKeyStroke2 = macroDefinition.getShortcut();
                    if (storeableKeyStroke2 == null || !storeableKeyStroke2.equals(storeableKeyStroke)) continue;
                    return macroDefinition;
                }
            }
        }
        return null;
    }

    public synchronized Map<String, MacroDefinition> getExpandableMacros(int n) {
        MacroStorage macroStorage = this.getStorage(n);
        TreeMap<String, MacroDefinition> treeMap = new TreeMap<String, MacroDefinition>(CaseInsensitiveComparator.INSTANCE);
        List<MacroGroup> list = macroStorage.getGroups();
        for (MacroGroup macroGroup : list) {
            for (MacroDefinition macroDefinition : macroGroup.getMacros()) {
                if (!macroDefinition.getExpandWhileTyping()) continue;
                treeMap.put(macroDefinition.getName(), macroDefinition);
            }
        }
        return treeMap;
    }

    private void dumpMacroInfo() {
        if (LogMgr.isTraceEnabled()) {
            LogMgr.logTrace(new CallerInfo(){}, "Current macro clients: " + this.macroClients);
            LogMgr.logTrace(new CallerInfo(){}, "Current storages: " + this.allMacros);
        }
    }

    private static class InstanceHolder {
        protected static MacroManager instance = new MacroManager();

        private InstanceHolder() {
        }
    }
}

