/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.parser;

import java.util.Set;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.DelimiterTester;
import workbench.util.CollectionUtil;

public class OracleDelimiterTester
implements DelimiterTester {
    private DelimiterDefinition alternateDelimiter = DelimiterDefinition.DEFAULT_ORA_DELIMITER;
    private boolean useAlternateDelimiter;
    private final Set<String> blockStart = CollectionUtil.caseInsensitiveSet("BEGIN", "DECLARE");
    private final Set<String> keywords = CollectionUtil.caseInsensitiveSet("CREATE", "CREATE OR REPLACE", "WITH");
    private final Set<String> singleLineCommands = CollectionUtil.caseInsensitiveSet("WHENEVER", "ECHO", "DESC", "DESCRIBE", "SET", "SHOW", "PROMPT");
    private final Set<String> types = CollectionUtil.caseInsensitiveSet("FUNCTION", "LIBRARY", "PACKAGE", "PACKAGE BODY", "PROCEDURE", "TRIGGER", "TYPE", "TYPE BODY");
    private final Set<String> plsqlCTETypes = CollectionUtil.caseInsensitiveSet("FUNCTION", "PROCEDURE");
    private SQLToken lastToken;
    private boolean isPLSQLStatement;
    private DelimiterDefinition defaultDelimiter = DelimiterDefinition.STANDARD_DELIMITER;

    public OracleDelimiterTester() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.oracle.sql.parser.types.altdelimiter", true);
        this.setRequireAlternateDelimiterForTypes(bl);
    }

    public void setRequireAlternateDelimiterForTypes(boolean bl) {
        if (bl) {
            this.types.add("TYPE");
        } else {
            this.types.remove("TYPE");
        }
    }

    @Override
    public boolean supportsMixedDelimiters() {
        return true;
    }

    @Override
    public void setDelimiter(DelimiterDefinition delimiterDefinition) {
        this.defaultDelimiter = delimiterDefinition;
    }

    @Override
    public void setAlternateDelimiter(DelimiterDefinition delimiterDefinition) {
        this.alternateDelimiter = delimiterDefinition.createCopy();
    }

    public DelimiterDefinition getAlternateDelimiter() {
        return this.alternateDelimiter;
    }

    public boolean isPLSQLHint(SQLToken sQLToken) {
        if (sQLToken == null) {
            return false;
        }
        if (!sQLToken.isComment()) {
            return false;
        }
        String string = sQLToken.getText();
        if (!string.startsWith("/*+") && !string.startsWith("--+")) {
            return false;
        }
        return string.toLowerCase().contains("with_plsql");
    }

    private boolean isCTEWithPLSQL(SQLToken sQLToken, SQLToken sQLToken2) {
        if (sQLToken == null || sQLToken2 == null) {
            return false;
        }
        if (!"WITH".equalsIgnoreCase(sQLToken2.getText())) {
            return false;
        }
        return this.plsqlCTETypes.contains(sQLToken.getText());
    }

    @Override
    public void currentToken(SQLToken sQLToken, boolean bl) {
        if (sQLToken == null) {
            return;
        }
        boolean bl2 = false;
        if (sQLToken.isComment() && !(bl2 = this.isPLSQLHint(sQLToken))) {
            return;
        }
        if (bl2 || this.isCTEWithPLSQL(sQLToken, this.lastToken)) {
            this.useAlternateDelimiter = true;
        } else if (this.useAlternateDelimiter && this.lastToken != null) {
            if (this.lastToken.getText().equals(this.alternateDelimiter.getDelimiter()) && bl) {
                this.useAlternateDelimiter = false;
            }
        } else if (this.blockStart.contains(sQLToken.getText()) && this.lastToken == null) {
            this.useAlternateDelimiter = true;
        } else if (this.lastToken != null && this.isPLSQLStatement) {
            boolean bl3 = this.useAlternateDelimiter = this.types.contains(sQLToken.getText()) && this.keywords.contains(this.lastToken.getText());
        }
        if (!sQLToken.isWhiteSpace() && !sQLToken.getContents().equalsIgnoreCase("EDITIONABLE")) {
            this.lastToken = sQLToken;
        }
        if (bl) {
            this.isPLSQLStatement = this.keywords.contains(sQLToken.getText());
        }
    }

    @Override
    public DelimiterDefinition getCurrentDelimiter() {
        if (this.useAlternateDelimiter) {
            return this.alternateDelimiter;
        }
        return this.defaultDelimiter;
    }

    @Override
    public void statementFinished() {
        this.useAlternateDelimiter = false;
        this.lastToken = null;
        this.isPLSQLStatement = false;
    }

    @Override
    public boolean supportsSingleLineStatements() {
        return true;
    }

    @Override
    public boolean isSingleLineStatement(SQLToken sQLToken, boolean bl) {
        if (sQLToken == null) {
            return false;
        }
        if (bl && !sQLToken.isWhiteSpace()) {
            String string = sQLToken.getText();
            if (string.charAt(0) == '@') {
                return true;
            }
            if (this.singleLineCommands.contains(string)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void lineEnd() {
    }
}

