/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.parser;

import workbench.db.DBID;
import workbench.db.WbConnection;
import workbench.resource.Settings;

public enum ParserType {
    Standard,
    Postgres,
    SqlServer,
    Oracle,
    MySQL;


    public static ParserType getTypeFromConnection(WbConnection wbConnection) {
        if (wbConnection == null) {
            return Standard;
        }
        return ParserType.getTypeFromDBID(wbConnection.getDbId());
    }

    public static ParserType getTypeFromDBID(String string) {
        if (string == null) {
            return Standard;
        }
        if (DBID.Postgres.isDB(string)) {
            return Postgres;
        }
        if (DBID.Vertica.isDB(string)) {
            return Postgres;
        }
        if (DBID.Greenplum.isDB(string)) {
            return Postgres;
        }
        if (DBID.Oracle.isDB(string)) {
            return Oracle;
        }
        if (DBID.SQL_Server.isDB(string)) {
            return SqlServer;
        }
        if ("adaptive_server_enterprise".equals(string)) {
            return SqlServer;
        }
        if ("excel".equals(string)) {
            return SqlServer;
        }
        if (DBID.MySQL.isDB(string)) {
            return MySQL;
        }
        if (DBID.MariaDB.isDB(string)) {
            return MySQL;
        }
        if (DBID.SQLite.isDB(string)) {
            return SqlServer;
        }
        String string2 = Settings.getInstance().getProperty("workbench.db." + string + ".parsertype", null);
        if (string2 != null) {
            try {
                return ParserType.valueOf(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Standard;
    }
}

