/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.parser;

import workbench.sql.DelimiterDefinition;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.DelimiterTester;

public class PostgresDelimiterTester
implements DelimiterTester {
    private SQLToken firstToken;
    private SQLToken lastToken;
    private DelimiterDefinition defaultDelimiter = DelimiterDefinition.STANDARD_DELIMITER;
    private DelimiterDefinition copyDelimiter = new DelimiterDefinition("\\.");
    private boolean isCopy = false;
    private boolean isCopyFromStdin = false;

    @Override
    public void setDelimiter(DelimiterDefinition delimiterDefinition) {
        this.defaultDelimiter = delimiterDefinition;
    }

    @Override
    public boolean supportsMixedDelimiters() {
        return true;
    }

    @Override
    public void setAlternateDelimiter(DelimiterDefinition delimiterDefinition) {
    }

    @Override
    public void currentToken(SQLToken sQLToken, boolean bl) {
        if (sQLToken == null) {
            return;
        }
        if (sQLToken.isComment() || sQLToken.isWhiteSpace()) {
            return;
        }
        if (this.firstToken == null) {
            this.firstToken = sQLToken;
            this.isCopy = sQLToken.getText().equalsIgnoreCase("copy");
        }
        if (this.isCopy && sQLToken.getText().equalsIgnoreCase("stdin") && this.lastToken != null && this.lastToken.getText().equalsIgnoreCase("from")) {
            this.isCopyFromStdin = true;
        }
        this.lastToken = sQLToken;
    }

    @Override
    public DelimiterDefinition getCurrentDelimiter() {
        if (this.isCopyFromStdin) {
            return this.copyDelimiter;
        }
        if (this.defaultDelimiter != null) {
            return this.defaultDelimiter;
        }
        return DelimiterDefinition.STANDARD_DELIMITER;
    }

    @Override
    public void statementFinished() {
        this.firstToken = null;
        this.lastToken = null;
        this.isCopy = false;
        this.isCopyFromStdin = false;
    }

    @Override
    public boolean supportsSingleLineStatements() {
        return true;
    }

    @Override
    public boolean isSingleLineStatement(SQLToken sQLToken, boolean bl) {
        if (sQLToken == null) {
            return false;
        }
        if (bl && !sQLToken.isWhiteSpace()) {
            String string = sQLToken.getText();
            char c = string.charAt(0);
            return c == '\\' || c == '@';
        }
        return false;
    }

    @Override
    public void lineEnd() {
    }
}

