/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.preparedstatement;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.preparedstatement.ParameterDefinition;
import workbench.util.CollectionUtil;

public class StatementParameters {
    private List<ParameterDefinition> parameterList;

    public StatementParameters(String string, WbConnection wbConnection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            int n = parameterMetaData.getParameterCount();
            if (n > 0) {
                this.parameterList = CollectionUtil.sizedArrayList(n);
                for (int i = 1; i <= n; ++i) {
                    int n2 = parameterMetaData.getParameterType(i);
                    ParameterDefinition parameterDefinition = new ParameterDefinition(i, n2);
                    this.parameterList.add(parameterDefinition);
                }
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error when checking parameters", exception);
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                throw new SQLException("Error retrieving statement parameters: " + exception.getClass().getName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(preparedStatement);
    }

    public StatementParameters(List<ParameterDefinition> list) {
        this.parameterList = CollectionUtil.sizedArrayList(list.size());
        this.parameterList.addAll(list);
    }

    public String getParameterName(int n) {
        return this.parameterList.get(n).getParameterName();
    }

    public int getParameterType(int n) {
        return this.parameterList.get(n).getType();
    }

    public Object getParameterValue(int n) {
        return this.parameterList.get(n).getValue();
    }

    public void applyParameter(PreparedStatement preparedStatement) throws SQLException {
        for (ParameterDefinition parameterDefinition : this.parameterList) {
            parameterDefinition.setStatementValue(preparedStatement);
        }
    }

    public boolean isValueValid(int n, String string) {
        return this.parameterList.get(n).isValueValid(string);
    }

    public void setParameterValue(int n, String string) {
        this.parameterList.get(n).setValue(string);
    }

    public int getParameterCount() {
        if (this.parameterList == null) {
            return 0;
        }
        return this.parameterList.size();
    }

    public boolean hasParameter() {
        return this.getParameterCount() > 0;
    }
}

