/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.syntax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class SqlKeywordHelper {
    private String dbId;
    private String aliasId;

    public static Set<String> getDefaultReservedWords() {
        return LazyHolder.keywords;
    }

    public SqlKeywordHelper() {
        this(null);
    }

    public SqlKeywordHelper(String string) {
        this.dbId = string;
        if (this.dbId != null) {
            this.aliasId = Settings.getInstance().getProperty("workbench.db." + this.dbId + ".aliasid", null);
        }
    }

    public Set<String> getReservedWords() {
        return this.loadKeywordsFromFile("reserved_words.wb");
    }

    public Set<String> getKeywords() {
        Set<String> set = this.loadKeywordsFromFile("keywords.wb");
        if (this.dbId != null) {
            String string = "workbench.db." + this.dbId + ".syntax.keywords";
            List<String> list = StringUtil.stringToList(Settings.getInstance().getProperty(string, ""), ",", true, true);
            set.addAll(list);
        }
        set.addAll(this.getReservedWords());
        return set;
    }

    public Set<String> getDataTypes() {
        return this.loadKeywordsFromFile("datatypes.wb");
    }

    public Set<String> getOperators() {
        return this.loadKeywordsFromFile("operators.wb");
    }

    public Set<String> getCreateTableTypes() {
        return this.loadKeywordsFromFile("create_table_types.wb");
    }

    public Set<String> getCreateViewTypes() {
        return this.loadKeywordsFromFile("create_view_types.wb");
    }

    public Set<String> getSqlFunctions() {
        Set<String> set = this.loadKeywordsFromFile("functions.wb");
        if (this.dbId != null) {
            String string = "workbench.db." + this.dbId + ".syntax.functions";
            List<String> list = StringUtil.stringToList(Settings.getInstance().getProperty(string, ""), ",", true, true);
            set.addAll(list);
        }
        return set;
    }

    public Set<String> loadKeywordsFromFile(String string) {
        Set<String> set = this.readFile(string);
        if (this.dbId != null) {
            Set<String> set2;
            Set<String> set3 = this.readFile(this.dbId + "." + string);
            if (set3 != null) {
                set.addAll(set3);
            }
            if (this.aliasId != null && (set2 = this.readFile(this.aliasId + "." + string)) != null) {
                set.addAll(set2);
            }
        }
        this.removeItems(set);
        return set;
    }

    private void removeItems(Set<String> set) {
        Set<String> set2 = CollectionUtil.caseInsensitiveSet();
        for (String string : set) {
            if (string.charAt(0) != '-' || !set.contains(string.substring(1))) continue;
            set2.add(string.substring(1));
            set2.add(string);
        }
        set.removeAll(set2);
    }

    private Set<String> readFile(String string) {
        Object object;
        Object object2;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        if (inputStream != null) {
            object2 = new BufferedReader(new InputStreamReader(inputStream));
            object = FileUtil.getLines((BufferedReader)object2, true, true);
            set.addAll((Collection<String>)object);
        }
        if (((File)(object2 = new File(Settings.getInstance().getConfigDir(), string))).exists()) {
            object = new CallerInfo(){};
            try {
                long l = System.nanoTime();
                BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object2));
                List<String> list = FileUtil.getLines(bufferedReader, true, true);
                set.addAll(list);
                long l2 = System.nanoTime() - l;
                LogMgr.logInfo((CallerInfo)object, "Reading keywords from: " + ((File)object2).getAbsolutePath() + " took " + String.format("%.2f", (double)l2 / 1000000.0) + "ms");
            }
            catch (Exception exception) {
                LogMgr.logError((CallerInfo)object, "Error reading external file: " + ((File)object2).getAbsolutePath(), exception);
            }
        }
        return set;
    }

    private static class LazyHolder {
        private static Set<String> keywords = new SqlKeywordHelper().getReservedWords();

        private LazyHolder() {
        }
    }
}

