/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import workbench.WbManager;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.gui.profiles.ProfileKey;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ConnectionDescriptor;
import workbench.sql.wbcommands.InvalidConnectionDescriptor;
import workbench.util.ArgumentParser;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class CommandLineConnectionHandler {
    private ArgumentParser cmdLine;
    private String profileNameArgument;
    private String profileGroupArgument;
    private String connectionArgument;

    public CommandLineConnectionHandler(ArgumentParser argumentParser, String string, String string2, String string3) {
        this.cmdLine = argumentParser;
        this.profileNameArgument = string;
        this.profileGroupArgument = string2;
        this.connectionArgument = string3;
    }

    public WbConnection getConnection(StatementRunnerResult statementRunnerResult, WbConnection wbConnection, String string, String string2) {
        String string3 = WbManager.getInstance().getCommandLine().getValue(this.connectionArgument, null);
        String string4 = this.cmdLine.getValue(this.connectionArgument, string3);
        if (StringUtil.isNonBlank(string4)) {
            try {
                ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor(string);
                ConnectionProfile connectionProfile = connectionDescriptor.parseDefinition(string4, wbConnection);
                if (connectionProfile != null) {
                    return ConnectionMgr.getInstance().getConnection(connectionProfile, string2);
                }
            }
            catch (InvalidConnectionDescriptor invalidConnectionDescriptor) {
                LogMgr.logError(new CallerInfo(){}, "Error connecting to database", invalidConnectionDescriptor);
                statementRunnerResult.addErrorMessage(invalidConnectionDescriptor.getLocalizedMessage());
                return null;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error connecting to database", exception);
                statementRunnerResult.addMessageByKey("ErrConnectDescriptor", string4);
                statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(exception));
                return null;
            }
        }
        return this.getConnectionFromKey(wbConnection, statementRunnerResult, string2);
    }

    private WbConnection getConnectionFromKey(WbConnection wbConnection, StatementRunnerResult statementRunnerResult, String string) {
        ProfileKey profileKey = this.getProfileKey();
        if (profileKey == null || wbConnection != null && wbConnection.getProfile().isProfileForKey(profileKey)) {
            return wbConnection;
        }
        ConnectionProfile connectionProfile = ConnectionMgr.getInstance().getProfile(profileKey);
        if (connectionProfile == null) {
            statementRunnerResult.addErrorMessageByKey("ErrProfileNotFound", profileKey.toString());
            return null;
        }
        try {
            return ConnectionMgr.getInstance().getConnection(profileKey, string);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error connecting to database", exception);
            statementRunnerResult.addMessageByKey("ErrConnectProfile", profileKey.toString());
            statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(exception));
            return null;
        }
    }

    public ProfileKey getProfileKey() {
        String string = this.cmdLine.getValue(this.profileNameArgument, WbManager.getInstance().getCommandLine().getValue(this.profileNameArgument));
        String string2 = this.cmdLine.getValue(this.profileGroupArgument, WbManager.getInstance().getCommandLine().getValue(this.profileGroupArgument));
        ProfileKey profileKey = null;
        if (string != null) {
            profileKey = new ProfileKey(string, string2);
        }
        return profileKey;
    }
}

