/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import workbench.db.DBID;
import workbench.db.DbObjectFinder;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.resource.ResourceMgr;
import workbench.sql.StatementRunnerResult;
import workbench.sql.VariablePool;
import workbench.util.ArgumentParser;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ConditionCheck {
    private static final Result OK = new Result();
    public static final String PARAM_IF_FILE_EXISTS = "ifFileExists";
    public static final String PARAM_IF_TABLE_EXISTS = "ifTableExists";
    public static final String PARAM_IF_FILE_NOTEXISTS = "ifNotFileExists";
    public static final String PARAM_IF_TABLE_NOTEXISTS = "ifNotTableExists";
    public static final String PARAM_IF_DEF = "ifDefined";
    public static final String PARAM_IF_NOTDEF = "ifNotDefined";
    public static final String PARAM_IF_EQUALS = "ifEquals";
    public static final String PARAM_IF_NOTEQ = "ifNotEquals";
    public static final String PARAM_IF_EMPTY = "ifEmpty";
    public static final String PARAM_IF_NOTEMPTY = "ifNotEmpty";
    public static final String PARAM_IS_DBMS = "isDBMS";
    public static final String PARAM_ISNOT_DBMS = "isNotDBMS";

    public static void addParameters(ArgumentParser argumentParser) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DBID dBID : DBID.values()) {
            arrayList.add(dBID.getId());
        }
        for (String string : ConditionCheck.allParameters()) {
            if (string.equals(PARAM_IS_DBMS) || string.equals(PARAM_ISNOT_DBMS)) {
                argumentParser.addArgument(string, arrayList);
                continue;
            }
            argumentParser.addArgument(string);
        }
    }

    public static boolean conditionSpecified(ArgumentParser argumentParser) {
        for (String string : ConditionCheck.allParameters()) {
            if (!argumentParser.isArgPresent(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCommandLineOK(StatementRunnerResult statementRunnerResult, ArgumentParser argumentParser) {
        int n = 0;
        for (String string : ConditionCheck.allParameters()) {
            if (!argumentParser.isArgPresent(string)) continue;
            ++n;
        }
        if (n <= 1) {
            return true;
        }
        statementRunnerResult.addErrorMessageByKey("ErrCondTooMany", StringUtil.listToString(ConditionCheck.allParameters(), ','));
        return false;
    }

    public static Result checkConditions(ArgumentParser argumentParser, WbConnection wbConnection) {
        return ConditionCheck.checkConditions(argumentParser, wbConnection, string -> new WbFile((String)string));
    }

    public static Result checkConditions(ArgumentParser argumentParser, WbConnection wbConnection, Function<String, WbFile> function) {
        Object object;
        String string;
        if (argumentParser.isArgPresent(PARAM_IF_DEF)) {
            string = argumentParser.getValue(PARAM_IF_DEF);
            if (!VariablePool.getInstance().isDefined(string)) {
                return new Result(PARAM_IF_DEF, string);
            }
        }
        if (argumentParser.isArgPresent(PARAM_IF_NOTDEF)) {
            string = argumentParser.getValue(PARAM_IF_NOTDEF);
            if (VariablePool.getInstance().isDefined(string)) {
                return new Result(PARAM_IF_NOTDEF, string);
            }
        }
        if (argumentParser.isArgPresent(PARAM_IF_EMPTY)) {
            string = argumentParser.getValue(PARAM_IF_EMPTY);
            object = VariablePool.getInstance().getParameterValue(string);
            if (StringUtil.isNonEmpty((CharSequence)object)) {
                return new Result(PARAM_IF_EMPTY, string);
            }
        }
        if (argumentParser.isArgPresent(PARAM_IF_NOTEMPTY)) {
            string = argumentParser.getValue(PARAM_IF_NOTEMPTY);
            object = VariablePool.getInstance().getParameterValue(string);
            if (StringUtil.isEmptyString((CharSequence)object)) {
                return new Result(PARAM_IF_NOTEMPTY, string);
            }
        }
        if (argumentParser.isArgPresent(PARAM_IF_EQUALS) && ((String[])(object = (string = argumentParser.getValue(PARAM_IF_EQUALS)).split("="))).length == 2) {
            String string2 = VariablePool.getInstance().getParameterValue(object[0]);
            if (string2 != null && string2.equals(object[1])) {
                return OK;
            }
            return new Result(PARAM_IF_EQUALS, (String)object[0], (String)object[1]);
        }
        if (argumentParser.isArgPresent(PARAM_IF_NOTEQ) && ((String[])(object = (string = argumentParser.getValue(PARAM_IF_NOTEQ)).split("="))).length == 2) {
            String string3 = VariablePool.getInstance().getParameterValue(object[0]);
            if (string3 == null || !string3.equals(object[1])) {
                return OK;
            }
            return new Result(PARAM_IF_NOTEQ, (String)object[0], (String)object[1]);
        }
        if (argumentParser.isArgPresent(PARAM_IS_DBMS)) {
            string = wbConnection == null ? "N/A" : wbConnection.getDbId();
            if (string.equalsIgnoreCase((String)(object = argumentParser.getValue(PARAM_IS_DBMS)))) {
                return OK;
            }
            return new Result(PARAM_IS_DBMS, string, (String)object);
        }
        if (argumentParser.isArgPresent(PARAM_ISNOT_DBMS)) {
            if (wbConnection == null) {
                return OK;
            }
            string = argumentParser.getValue(PARAM_ISNOT_DBMS);
            object = wbConnection.getDbId();
            if (!((String)object).equalsIgnoreCase(string)) {
                return OK;
            }
            return new Result(PARAM_ISNOT_DBMS, (String)object, string);
        }
        if (argumentParser.isArgPresent(PARAM_IF_FILE_EXISTS)) {
            string = argumentParser.getValue(PARAM_IF_FILE_EXISTS);
            object = function.apply(string);
            if (((File)object).exists()) {
                return OK;
            }
            return new Result(PARAM_IF_FILE_EXISTS, string);
        }
        if (argumentParser.isArgPresent(PARAM_IF_FILE_NOTEXISTS)) {
            string = argumentParser.getValue(PARAM_IF_FILE_NOTEXISTS);
            object = function.apply(string);
            if (!((File)object).exists()) {
                return OK;
            }
            return new Result(PARAM_IF_FILE_NOTEXISTS, string);
        }
        if (argumentParser.isArgPresent(PARAM_IF_TABLE_EXISTS)) {
            string = argumentParser.getValue(PARAM_IF_TABLE_EXISTS);
            if (ConditionCheck.tableExists(wbConnection, string)) {
                return OK;
            }
            return new Result(PARAM_IF_TABLE_EXISTS, string);
        }
        if (argumentParser.isArgPresent(PARAM_IF_TABLE_NOTEXISTS)) {
            string = argumentParser.getValue(PARAM_IF_TABLE_NOTEXISTS);
            if (!ConditionCheck.tableExists(wbConnection, string)) {
                return OK;
            }
            return new Result(PARAM_IF_TABLE_NOTEXISTS, string);
        }
        return OK;
    }

    private static boolean tableExists(WbConnection wbConnection, String string) {
        if (wbConnection == null) {
            return false;
        }
        TableIdentifier tableIdentifier = new DbObjectFinder(wbConnection).findTable(new TableIdentifier(string));
        return tableIdentifier != null;
    }

    public static String getMessage(String string, Result result) {
        String string2 = ResourceMgr.getFormattedString("Err_NotExecuted", string);
        return ResourceMgr.getFormattedString("Err_" + result.getFailedCondition(), string2, result.getVariable(), result.getExpectedValue());
    }

    private static List<String> allParameters() {
        Field[] fieldArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : fieldArray = ConditionCheck.class.getDeclaredFields()) {
            String string = field.getName();
            if (!string.startsWith("PARAM_")) continue;
            try {
                arrayList.add((String)field.get(null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static class Result {
        private boolean conditionIsOK;
        private String failedParameter;
        private String variableName;
        private String expectedValue;

        public Result() {
            this.conditionIsOK = true;
        }

        public Result(String string, String string2) {
            this.conditionIsOK = false;
            this.failedParameter = string;
            this.variableName = string2;
        }

        public Result(String string, String string2, String string3) {
            this.conditionIsOK = false;
            this.failedParameter = string;
            this.variableName = string2;
            this.expectedValue = string3;
        }

        public boolean isOK() {
            return this.conditionIsOK;
        }

        public String getExpectedValue() {
            return this.expectedValue;
        }

        public String getFailedCondition() {
            return this.failedParameter;
        }

        public String getVariable() {
            return this.variableName;
        }
    }
}

