/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.StringReader;
import java.sql.SQLException;
import workbench.db.postgres.PgCopyManager;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class PgCopyCommand
extends SqlCommand {
    public static final String VERB = "COPY";

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(ParserType.Postgres, (CharSequence)string);
        SQLToken sQLToken = sQLLexer.getNextToken(true, true);
        SQLToken sQLToken2 = null;
        while (sQLToken != null) {
            if (!sQLToken.isComment() && !sQLToken.isWhiteSpace()) {
                if (bl && sQLToken.getText().equals(";")) {
                    n = sQLToken.getCharEnd();
                    n = StringUtil.findNextLineStart(string, n);
                    break;
                }
                if (sQLToken.getText().equalsIgnoreCase("stdin") && sQLToken2 != null && sQLToken2.getText().equalsIgnoreCase("FROM")) {
                    bl = true;
                }
                if (sQLToken.getText().equalsIgnoreCase("stdout") && sQLToken2 != null && sQLToken2.getText().equalsIgnoreCase("TO")) {
                    bl2 = true;
                    break;
                }
                sQLToken2 = sQLToken;
            }
            string2 = string2 + sQLToken.getText();
            sQLToken = sQLLexer.getNextToken(true, true);
        }
        if (bl) {
            return this.processCopyIn(string, string2, n);
        }
        if (bl2) {
            return this.processCopyOut(string);
        }
        return super.execute(string);
    }

    private StatementRunnerResult processCopyOut(String string) {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        try {
            this.runner.setSavepoint();
            PgCopyManager pgCopyManager = new PgCopyManager(this.currentConnection);
            if (this.currentConnection.getDbSettings().getBoolProperty("copy.stdout.text", true)) {
                String string2 = pgCopyManager.copyStdOutToString(string);
                if (string2 != null) {
                    statementRunnerResult.addMessage(string2);
                    statementRunnerResult.setSuccess();
                    this.appendSuccessMessage(statementRunnerResult);
                }
            } else {
                DataStore dataStore = pgCopyManager.copyStdOutToDataStore(string);
                if (dataStore != null) {
                    statementRunnerResult.addDataStore(dataStore);
                    statementRunnerResult.setSuccess();
                    this.appendSuccessMessage(statementRunnerResult);
                }
            }
            this.runner.releaseSavepoint();
        }
        catch (Exception exception) {
            this.runner.rollbackSavepoint();
            this.addErrorInfo(statementRunnerResult, string, exception);
            LogMgr.logUserSqlError(new CallerInfo(){}, string, exception);
        }
        return statementRunnerResult;
    }

    private StatementRunnerResult processCopyIn(String string, String string2, int n) {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string2);
        try {
            this.runner.setSavepoint();
            StringReader stringReader = new StringReader(string);
            stringReader.skip(n);
            PgCopyManager pgCopyManager = new PgCopyManager(this.currentConnection);
            pgCopyManager.copyFromStdin(string2, stringReader);
            long l = pgCopyManager.processStreamData();
            statementRunnerResult.addUpdateCountMsg((int)l);
            statementRunnerResult.setSuccess();
            this.appendSuccessMessage(statementRunnerResult);
            this.runner.releaseSavepoint();
        }
        catch (Exception exception) {
            this.runner.rollbackSavepoint();
            this.addErrorInfo(statementRunnerResult, string2, exception);
            LogMgr.logUserSqlError(new CallerInfo(){}, string2, exception);
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return VERB;
    }
}

