/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import workbench.db.ConnectionMgr;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.compare.TableDataDiff;
import workbench.db.compare.TableDeleteSync;
import workbench.db.compare.TableDiffStatus;
import workbench.db.exporter.BlobMode;
import workbench.db.importer.TableDependencySorter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.CommonDiffParameters;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbDataDiff
extends SqlCommand {
    public static final String VERB = "WbDataDiff";
    public static final String PARAM_INCLUDE_DELETE = "includeDelete";
    public static final String PARAM_IGNORE_COLS = "ignoreColumns";
    public static final String PARAM_OUTPUT_TYPE = "type";
    public static final String PARAM_ALTERNATE_KEYS = "alternateKey";
    public static final String PARAM_EXCLUDE_REAL_PK = "excludeRealPK";
    public static final String PARAM_EXCLUDE_IGNORED = "excludeIgnored";
    public static final String PARAM_SINGLE_FILE = "singleFile";
    public static final String PARAM_IGNORE_MISSING_TARGET = "ignoreMissingTarget";
    private WbFile outputDir;
    private TableDataDiff dataDiff;
    private TableDeleteSync deleteSync;
    private boolean xmlOutput;
    private CommonDiffParameters params;

    public WbDataDiff() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(PARAM_INCLUDE_DELETE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("createDir");
        this.cmdLine.addArgument(PARAM_IGNORE_COLS);
        this.cmdLine.addArgument(PARAM_OUTPUT_TYPE, CollectionUtil.arrayList("sql", "xml"));
        this.cmdLine.addArgument("blobType", BlobMode.getTypes());
        this.cmdLine.addArgument("useCDATA", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("clobAsFile", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("clobFileThreshold");
        this.cmdLine.addArgument("useCDATA", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_ALTERNATE_KEYS, ArgumentType.Repeatable);
        this.cmdLine.addArgument(PARAM_EXCLUDE_REAL_PK, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_EXCLUDE_IGNORED, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_SINGLE_FILE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_IGNORE_MISSING_TARGET, ArgumentType.BoolSwitch);
        CommonArgs.addCheckDepsParameter(this.cmdLine);
        CommonArgs.addSqlDateLiteralParameter(this.cmdLine);
        CommonArgs.addProgressParameter(this.cmdLine);
        this.params = new CommonDiffParameters(this.cmdLine, this.getBaseDir());
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    private String getWrongArgumentsMessage() {
        String string = ResourceMgr.getString("ErrDataDiffWrongParms");
        string = string.replace("%date_literal_default%", Settings.getInstance().getDefaultDiffDateLiteralType());
        string = string.replace("%encoding_default%", Settings.getInstance().getDefaultEncoding());
        return string;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.dataDiff != null) {
            this.dataDiff.cancel();
        }
        if (this.deleteSync != null) {
            this.deleteSync.cancel();
        }
    }

    protected Map<String, Set<String>> getAlternateKeys(ArgumentParser argumentParser, StatementRunnerResult statementRunnerResult) {
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>(CaseInsensitiveComparator.INSTANCE);
        List<String> list = argumentParser.getList(PARAM_ALTERNATE_KEYS);
        if (CollectionUtil.isEmpty(list)) {
            return treeMap;
        }
        CaseInsensitiveComparator caseInsensitiveComparator = new CaseInsensitiveComparator();
        caseInsensitiveComparator.setIgnoreSQLQuotes(true);
        for (String string : list) {
            String[] stringArray = string.split("=");
            if (stringArray != null && stringArray.length == 2) {
                List<String> list2 = StringUtil.stringToList(stringArray[1], ",", true, true, false, true);
                TreeSet<String> treeSet = new TreeSet<String>(caseInsensitiveComparator);
                treeSet.addAll(list2);
                treeMap.put(stringArray[0], treeSet);
                continue;
            }
            statementRunnerResult.addWarning(ResourceMgr.getFormattedString("ErrIgnoringArg", PARAM_ALTERNATE_KEYS, string));
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public StatementRunnerResult execute(String var1_1) throws SQLException, Exception {
        var2_2 = new StatementRunnerResult(this.messageLogger);
        this.cmdLine.parse(this.getCommandLine(var1_1));
        if (this.displayHelp(var2_2)) {
            return var2_2;
        }
        if (this.cmdLine.getArgumentCount() == 0) {
            var2_2.addErrorMessage(this.getWrongArgumentsMessage());
            return var2_2;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(var2_2, this.cmdLine, this.getWrongArgumentsMessage());
            return var2_2;
        }
        var3_3 = this.evaluateFileArgument(this.cmdLine.getValue("file"));
        if (var3_3 == null) {
            var2_2.addErrorMessage(ResourceMgr.getString("ErrDataDiffNoFile"));
            var2_2.addMessage(this.getWrongArgumentsMessage());
            return var2_2;
        }
        this.outputDir = new WbFile(var3_3.getAbsoluteFile().getParentFile());
        var4_4 = this.cmdLine.getValue("encoding");
        if (var4_4 == null) {
            var4_4 = Settings.getInstance().getDefaultEncoding();
        }
        var4_4 = EncodingUtil.cleanupEncoding(var4_4);
        var5_5 = this.cmdLine.getBoolean("createDir", false);
        var6_6 = this.cmdLine.getValue("sqlDateLiterals");
        if (var6_6 == null) {
            var6_6 = "jdbc";
        }
        if (var5_5 && !this.outputDir.exists()) {
            var7_7 = this.outputDir.mkdirs();
            if (var7_7) {
                var2_2.addMessage(ResourceMgr.getFormattedString("MsgDirCreated", new Object[]{this.outputDir.getFullPath()}));
            } else {
                var2_2.addErrorMessageByKey("ErrCreateDir", new String[]{this.outputDir.getFullPath()});
                LogMgr.logError(new CallerInfo(){}, "Could not create output directory: " + this.outputDir.getFullPath(), null);
                return var2_2;
            }
        }
        if (!this.outputDir.exists()) {
            var2_2.addErrorMessageByKey("ErrOutputDirNotFound", new String[]{this.outputDir.getFullPath()});
            return var2_2;
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(7);
        }
        this.params.setMonitor(this.rowMonitor);
        var7_8 = this.params.getTargetConnection(this.currentConnection, var2_2);
        if (!var2_2.isSuccess()) {
            return var2_2;
        }
        var8_9 = this.params.getSourceConnection(this.currentConnection, var2_2);
        if (var8_9 == null) {
            this.close(var7_8);
        }
        if (!var2_2.isSuccess()) {
            return var2_2;
        }
        var9_10 = this.cmdLine.getBoolean("includeDelete", true);
        var10_11 = this.cmdLine.getBoolean("checkDependencies", true);
        var11_12 = this.cmdLine.getBoolean("ignoreMissingTarget", false);
        var12_13 = Settings.getInstance().getExternalEditorLineEnding();
        var13_14 = this.cmdLine.getBoolean("useCDATA", false);
        this.params.setIgnoreMissing(var11_12);
        var14_15 = this.params.getTables(var8_9, var7_8);
        var15_16 = var14_15.referenceTables.size();
        var16_17 = this.params.getMissingReferenceTables();
        if (var16_17.size() > 0) {
            for (String var18_19 : var16_17) {
                var19_20 = ResourceMgr.getFormattedString("ErrRefTableNotFound", new Object[]{var18_19});
                var2_2.addWarning(var19_20);
            }
            var2_2.addMessageNewLine();
        }
        if ((var16_17 = this.params.getMissingTargetTables()).size() > 0) {
            for (String var18_19 : var16_17) {
                var19_20 = ResourceMgr.getFormattedString("ErrTargetTableNotFound", new Object[]{var18_19});
                var2_2.addWarning(var19_20);
            }
            var2_2.addMessageNewLine();
        }
        if (var15_16 == 0) {
            LogMgr.logWarning(new CallerInfo(){}, "No tables found.");
            var2_2.addWarningByKey("ErrNoTablesFound");
            this.close(var7_8);
            this.close(var8_9);
            return var2_2;
        }
        this.dataDiff = new TableDataDiff(var8_9, var7_8);
        this.dataDiff.setSqlDateLiteralType(var6_6);
        this.dataDiff.setIgnoreMissingTarget(var11_12);
        var17_18 = this.cmdLine.getValue("type");
        if (StringUtil.isBlank((CharSequence)var17_18)) {
            var17_18 = "sql";
        }
        this.xmlOutput = false;
        if ("xml".equalsIgnoreCase((String)var17_18)) {
            this.dataDiff.setTypeXml(var13_14);
            this.xmlOutput = true;
        } else if ("sql".equalsIgnoreCase((String)var17_18)) {
            this.dataDiff.setTypeSql();
        } else {
            var2_2.addErrorMessage("Illegal output type: " + (String)var17_18);
            this.close(var7_8);
            this.close(var8_9);
            return var2_2;
        }
        var18_19 = this.cmdLine.getValue("blobType");
        if (StringUtil.isNonBlank(var18_19)) {
            this.dataDiff.setBlobMode(var18_19);
        }
        if (var19_21 = this.cmdLine.getBoolean("clobAsFile", false)) {
            this.dataDiff.setClobAsFile(var4_4, this.cmdLine.getIntValue("clobFileThreshold", -1));
        }
        this.dataDiff.setRowMonitor(this.rowMonitor);
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(5);
        }
        CommonArgs.setProgressInterval(this.dataDiff, this.cmdLine);
        var20_22 = CommonArgs.getListArgument(this.cmdLine, "ignoreColumns");
        this.dataDiff.setColumnsToIgnore(var20_22);
        var21_23 = this.getAlternateKeys(this.cmdLine, var2_2);
        this.dataDiff.setAlternateKeys(var21_23);
        this.dataDiff.setExcludeRealPK(this.cmdLine.getBoolean("excludeRealPK", false));
        this.dataDiff.setExcludeIgnoredColumns(this.cmdLine.getBoolean("excludeIgnored", false));
        if (var11_12) {
            var22_24 = this.cmdLine.getValue("targetSchema");
            if (StringUtil.isBlank(var22_24) && !(var23_26 = this.params.getSchemas(var14_15.targetTables)).isEmpty()) {
                var22_24 = var23_26.iterator().next();
            }
            this.dataDiff.setTargetSchema(var22_24);
        }
        var22_25 = this.cmdLine.getBoolean("singleFile", false);
        try {
            for (var23_27 = 0; var23_27 < var15_16; ++var23_27) {
                var24_29 = var14_15.referenceTables.get(var23_27);
                var25_30 = var14_15.targetTables.get(var23_27);
                var26_31 = this.createFilename("update", var25_30);
                var27_32 = this.createFilename("insert", var25_30 == null ? var24_29 : var25_30);
                var28_33 = var26_31 == null ? null : EncodingUtil.createWriter(var26_31, var4_4, false);
                var29_34 = var27_32 == null ? null : EncodingUtil.createWriter(var27_32, var4_4, false);
                try {
                    this.dataDiff.setOutputWriters(var28_33, var29_34, var12_13, var4_4);
                    this.dataDiff.setBaseDir(this.outputDir);
                    var30_35 /* !! */  = this.dataDiff.setTableName(var24_29, var25_30);
                    switch (6.$SwitchMap$workbench$db$compare$TableDiffStatus[var30_35 /* !! */ .ordinal()]) {
                        case 1: {
                            this.dataDiff.doSync();
                            ** break;
lbl129:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            var2_2.addWarning(ResourceMgr.getFormattedString("ErrTableNotFound", new Object[]{var24_29.getTableName()}));
                            ** break;
lbl133:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            var2_2.addWarning(ResourceMgr.getFormattedString("ErrTableNotFound", new Object[]{var25_30.getTableName()}));
                            ** break;
lbl137:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            var2_2.addWarning(ResourceMgr.getFormattedString("ErrDataDiffNoPK", new Object[]{var24_29.getTableName()}));
                            ** break;
lbl141:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            var2_2.addWarning(ResourceMgr.getFormattedString("ErrDataDiffNoTableMatch", new Object[]{var24_29.getTableName(), var25_30.getTableName()}));
                            break;
                        }
                        ** default:
lbl146:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    FileUtil.closeQuietely(var28_33);
                    FileUtil.closeQuietely(var29_34);
                }
                if (!var9_10 || this.isCancelled || var25_30 == null) continue;
                var30_35 /* !! */  = this.createFilename("delete", var25_30);
                var31_36 = EncodingUtil.createWriter((File)var30_35 /* !! */ , var4_4, false);
                try {
                    this.deleteSync = new TableDeleteSync(var7_8, var8_9);
                    CommonArgs.setProgressInterval(this.deleteSync, this.cmdLine);
                    this.deleteSync.setRowMonitor(this.rowMonitor);
                    this.deleteSync.setOutputWriter(var31_36, var12_13, var4_4);
                    if ("xml".equalsIgnoreCase((String)var17_18)) {
                        this.deleteSync.setTypeXml(var13_14);
                    } else if ("sql".equalsIgnoreCase((String)var17_18)) {
                        this.deleteSync.setTypeSql();
                    }
                    var32_38 = var21_23.get(var25_30.getTableName());
                    var33_39 = this.deleteSync.setTableName(var24_29, var25_30, var32_38);
                    if (var33_39 == TableDiffStatus.OK) {
                        this.deleteSync.doSync();
                        continue;
                    }
                    if (var33_39 != TableDiffStatus.NoPK) continue;
                    LogMgr.logDebug(new CallerInfo(){}, "No delete performed for " + var25_30.getTableName() + " because not PK was found");
                    continue;
                }
                finally {
                    FileUtil.closeQuietely(var31_36);
                }
            }
        }
        catch (Exception var23_28) {
            LogMgr.logError(new CallerInfo(){}, "Error during diff", var23_28);
            var2_2.addErrorMessage(ExceptionUtil.getDisplay(var23_28));
        }
        try {
            if (var2_2.isSuccess() && !this.isCancelled) {
                this.writeOutput(var3_3, var14_15, var4_4, var8_9, var7_8, var10_11, var22_25);
                var2_2.addMessageNewLine();
                var2_2.addMessage(ResourceMgr.getFormattedString("MsgDataDiffSuccess", new Object[]{var15_16, var3_3.getFullPath()}));
            }
        }
        finally {
            this.close(var7_8);
            this.close(var8_9);
            if (LogMgr.isDebugEnabled()) {
                ConnectionMgr.getInstance().dumpConnections();
            }
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(WbFile wbFile, CommonDiffParameters.TableMapping tableMapping, String string, WbConnection wbConnection, WbConnection wbConnection2, boolean bl, boolean bl2) throws IOException {
        String string2 = "-encoding='" + EncodingUtil.cleanupEncoding(string) + "'";
        Writer writer = null;
        String string3 = Settings.getInstance().getExternalEditorLineEnding();
        int n = tableMapping.referenceTables.size();
        try {
            WbFile wbFile2;
            int n2;
            TableIdentifier tableIdentifier;
            int n3;
            writer = EncodingUtil.createWriter(wbFile, string, false);
            String string4 = wbConnection.getDisplayString();
            String string5 = wbConnection2.getDisplayString();
            int n4 = string4.length();
            if (string5.length() > n4) {
                n4 = string5.length();
            }
            String string6 = StringUtil.padRight("-- ", n4, '*');
            string6 = string6 + string3;
            if (this.xmlOutput) {
                writer.write("<?xml version=\"1.0\" encoding=\"" + string + "\"?>" + string3);
                writer.write("<!-- " + string3);
                writer.write("  ** Generated by SQL Workbench/J at: " + StringUtil.getCurrentTimestampWithTZString() + " **" + string3);
                writer.write(string3);
                writer.write("  The following XML files describe the diff result to migrate the data in" + string3);
                writer.write("  " + string5 + string3);
                writer.write("  to match the data from" + string3);
                writer.write("  " + string4 + string3);
                writer.write("-->" + string3);
                writer.write(string3);
                writer.write("<data-diff>" + string3);
                writer.write("  <summary>" + string3);
                for (n3 = 0; n3 < n; ++n3) {
                    tableIdentifier = tableMapping.referenceTables.get(n3);
                    TableIdentifier tableIdentifier2 = tableMapping.targetTables.get(n3);
                    writer.write("    <mapping>" + string3);
                    writer.write("      <reference-table>" + tableIdentifier.getFullyQualifiedName(wbConnection) + "</reference-table>" + string3);
                    writer.write("      <target-table>" + tableIdentifier2.getFullyQualifiedName(wbConnection2) + "</target-table>" + string3);
                    writer.write("    </mapping>" + string3);
                }
                writer.write("  </summary>" + string3 + string3);
                writer.write("  <files>" + string3);
                if (bl) {
                    writer.write("    <!-- UPDATE/INSERT migrations are sorted according to their foreign key relationship --> " + string3);
                }
            } else {
                writer.write(string6);
                writer.write("-- The following script will migrate the data in: " + string3);
                writer.write("-- " + string5 + string3);
                writer.write("-- " + string3);
                writer.write("-- to match the data from: " + string3);
                writer.write("-- " + string4 + string3);
                writer.write("-- " + string3);
                writer.write("-- Tables included:" + string3);
                for (n3 = 0; n3 < tableMapping.targetTables.size(); ++n3) {
                    tableIdentifier = tableMapping.targetTables.get(n3);
                    if (tableIdentifier == null) {
                        writer.write("-- missing: " + tableMapping.referenceTables.get(n3) + string3);
                        continue;
                    }
                    writer.write("-- " + tableIdentifier.getTableExpression() + string3);
                }
                writer.write("-- " + string3);
                writer.write("-- Generated by SQL Workbench/J at: " + StringUtil.getCurrentTimestampWithTZString() + string3);
                writer.write(string6);
                writer.write(string3);
                if (!bl2) {
                    writer.write("-- ----------------------" + string3);
                    writer.write("-- UPDATE/INSERT scripts" + string3);
                    writer.write("-- ----------------------" + string3);
                }
            }
            TableDependencySorter tableDependencySorter = new TableDependencySorter(wbConnection2);
            if (bl) {
                if (this.rowMonitor != null && tableMapping.targetTables.size() > 1) {
                    this.rowMonitor.setMonitorType(7);
                    this.rowMonitor.setCurrentObject(ResourceMgr.getString("MsgDataDiffSortInsert"), -1L, -1L);
                }
                tableDependencySorter.sortForInsert(tableMapping.targetTables);
            }
            int n5 = 0;
            for (n2 = 0; n2 < tableMapping.targetTables.size(); ++n2) {
                Object object = tableMapping.targetTables.get(n2);
                if (object == null) {
                    object = tableMapping.referenceTables.get(n2);
                }
                WbFile comparable = this.createFilename("insert", (TableIdentifier)object);
                wbFile2 = this.createFilename("update", (TableIdentifier)object);
                if (this.xmlOutput) {
                    writer.write("    ");
                    TableDataDiff.writeTableNameTag(writer, "table", (TableIdentifier)object);
                    writer.write(string3);
                    if (comparable.exists()) {
                        if (comparable.length() > 0L) {
                            writer.write("      <file-name type=\"insert\">" + comparable.getName() + "</file-name>" + string3);
                        } else {
                            comparable.delete();
                            writer.write("      <!-- No INSERTs for " + ((TableIdentifier)object).getObjectName() + " necessary -->" + string3);
                        }
                    }
                    if (wbFile2.exists()) {
                        if (wbFile2.length() > 0L) {
                            writer.write("      <file-name type=\"update\">" + wbFile2.getName() + "</file-name>" + string3);
                        } else {
                            wbFile2.delete();
                            writer.write("      <!-- No UPDATEs for " + ((TableIdentifier)object).getObjectName() + " necessary -->" + string3);
                        }
                    }
                    writer.write("    </table>" + string3);
                    continue;
                }
                if (comparable != null && comparable.exists()) {
                    if (comparable.length() > 0L) {
                        if (bl2) {
                            writer.write("-- -------------------" + string3);
                            writer.write("-- INSERTS for " + ((TableIdentifier)object).getFullyQualifiedName(wbConnection2) + string3);
                            writer.write("-- -------------------" + string3);
                            this.mergeInto(writer, comparable, string, string3);
                            comparable.delete();
                        } else {
                            writer.write("WbInclude -file='" + comparable.getName() + "' " + string2 + ";" + string3);
                        }
                        ++n5;
                    } else {
                        comparable.delete();
                        writer.write("-- No INSERTs for " + ((TableIdentifier)object).getObjectName() + " necessary" + string3);
                    }
                }
                if (wbFile2 == null || !wbFile2.exists()) continue;
                if (wbFile2.length() > 0L) {
                    if (bl2) {
                        writer.write("-- -------------------" + string3);
                        writer.write("-- UPDATES for " + ((TableIdentifier)object).getFullyQualifiedName(wbConnection2) + string3);
                        writer.write("-- -------------------" + string3);
                        this.mergeInto(writer, wbFile2, string, string3);
                        wbFile2.delete();
                    } else {
                        writer.write("WbInclude -file='" + wbFile2.getName() + "' " + string2 + ";" + string3);
                    }
                    ++n5;
                    continue;
                }
                wbFile2.delete();
                writer.write("-- No UPDATEs for " + ((TableIdentifier)object).getObjectName() + " necessary" + string3);
            }
            if (n5 > 0 && !this.xmlOutput) {
                writer.write(string3 + "COMMIT;" + string3);
            }
            n5 = 0;
            if (bl && tableMapping.targetTables.size() > 1) {
                if (this.rowMonitor != null) {
                    this.rowMonitor.setMonitorType(7);
                    this.rowMonitor.setCurrentObject(ResourceMgr.getString("MsgDataDiffSortDelete"), -1L, -1L);
                }
                tableDependencySorter.sortForDelete(tableMapping.targetTables, false);
            }
            n2 = 1;
            for (TableIdentifier tableIdentifier2 : tableMapping.targetTables) {
                if (tableIdentifier2 == null || !(wbFile2 = this.createFilename("delete", tableIdentifier2)).exists()) continue;
                if (wbFile2.length() > 0L) {
                    if (this.xmlOutput) {
                        if (n2 != 0) {
                            n2 = 0;
                            if (bl) {
                                writer.write(string3 + "    <!-- DELETE migrations are sorted according to their foreign key relationship --> " + string3);
                            }
                        }
                        writer.write("    ");
                        TableDataDiff.writeTableNameTag(writer, "table", tableIdentifier2);
                        writer.write(string3);
                        writer.write("      <file-name type=\"delete\">" + wbFile2.getName() + "</file-name>" + string3);
                        writer.write("    </table>" + string3);
                    } else {
                        if (n2 != 0) {
                            n2 = 0;
                            writer.write(string3);
                            writer.write("-- ---------------" + string3);
                            writer.write("-- DELETE " + (bl2 ? "statements" : "scripts") + string3);
                            writer.write("-- ---------------" + string3);
                        }
                        if (bl2) {
                            this.mergeInto(writer, wbFile2, string, string3);
                            wbFile2.delete();
                        } else {
                            writer.write("WbInclude -file='" + wbFile2.getName() + "' " + string2 + ";" + string3);
                        }
                    }
                    ++n5;
                    continue;
                }
                if (this.xmlOutput) {
                    writer.write("    <!-- No DELETEs for " + tableIdentifier2.getObjectName() + " necessary -->" + string3);
                } else {
                    writer.write(string3 + "-- No DELETEs for " + tableIdentifier2.getObjectName() + " necessary" + string3);
                }
                wbFile2.delete();
            }
            if (this.xmlOutput) {
                writer.write("  </files>" + string3);
                writer.write("</data-diff>" + string3);
            } else if (n5 > 0) {
                writer.write(string3 + "COMMIT;" + string3);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(writer);
            throw throwable;
        }
        FileUtil.closeQuietely(writer);
    }

    private void close(WbConnection wbConnection) {
        if (wbConnection != null && wbConnection != this.currentConnection) {
            try {
                wbConnection.disconnect();
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not disconnect target connection " + wbConnection.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeInto(Writer writer, WbFile wbFile, String string, String string2) throws IOException {
        if (!wbFile.exists() || wbFile.length() == 0L) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = EncodingUtil.createBufferedReader(wbFile, string);
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (!string3.startsWith("--") && StringUtil.isNonEmpty(string3)) {
                    writer.write(string3);
                    writer.write(string2);
                }
                string3 = bufferedReader.readLine();
            }
            writer.write(string2);
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
        }
    }

    private WbFile createFilename(String string, TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        if (this.xmlOutput) {
            return new WbFile(this.outputDir, StringUtil.makeFilename(tableIdentifier.getTableName() + "_$" + string + ".xml"));
        }
        return new WbFile(this.outputDir, StringUtil.makeFilename(tableIdentifier.getTableName() + "_$" + string + ".sql"));
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    public boolean shouldEndTransaction() {
        return true;
    }
}

