/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.MessagePriority;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbEcho
extends SqlCommand {
    public static final String VERB = "WbEcho";
    private static final String ARG_MESSAGE = "message";
    private static final String ARG_MODE = "mode";
    private static final String ARG_IMPORTANT = "important";

    public WbEcho() {
        this.cmdLine = new ArgumentParser();
        CommonArgs.addEncodingParameter(this.cmdLine);
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addArgument(ARG_MESSAGE, ArgumentType.RepeatableValue);
        this.cmdLine.addArgument(ARG_IMPORTANT, ArgumentType.BoolSwitch);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Mode mode : Mode.values()) {
            arrayList.add(mode.toString());
        }
        this.cmdLine.addArgument(ARG_MODE, arrayList);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.cmdLine.hasArguments()) {
            List<String> list = this.cmdLine.getList(ARG_MESSAGE);
            String string3 = null;
            if (list != null && list.size() > 0) {
                string3 = StringUtil.listToString(list, StringUtil.LINE_TERMINATOR, false);
            }
            if (string3 != null) {
                WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
                Mode mode = Mode.byString(this.cmdLine.getValue(ARG_MODE), Mode.normal);
                if (mode == Mode.log) {
                    LogMgr.logInfo(new CallerInfo(){}, string3);
                }
                if (wbFile != null) {
                    String string4 = this.cmdLine.getValue("encoding", Settings.getInstance().getDefaultEncoding());
                    string4 = EncodingUtil.cleanupEncoding(string4);
                    try {
                        this.printToFile(wbFile, string3, string4, mode);
                    }
                    catch (IOException iOException) {
                        LogMgr.logError(new CallerInfo(){}, "Could not write message to file " + wbFile, iOException);
                    }
                }
                if (this.cmdLine.getBoolean(ARG_IMPORTANT, false)) {
                    statementRunnerResult.setMessagePriority(MessagePriority.high);
                }
                statementRunnerResult.addMessage(string3);
                statementRunnerResult.setSuccess();
                return statementRunnerResult;
            }
        }
        if (string2 != null && string2.startsWith("!!")) {
            statementRunnerResult.setMessagePriority(MessagePriority.high);
            string2 = string2.replaceFirst("!!\\s*", "");
        }
        statementRunnerResult.addMessage(string2);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    private void printToFile(WbFile wbFile, String string, String string2, Mode mode) throws IOException {
        if (mode == Mode.prepend && !wbFile.exists()) {
            LogMgr.logWarning(new CallerInfo(){}, "Cannot prepend to file " + wbFile + " since it does not exist!");
        }
        if (mode == Mode.prepend) {
            FileUtil.writeAtStart(wbFile, string + StringUtil.LINE_TERMINATOR, string2);
        } else if (mode == Mode.append) {
            FileUtil.writeString(wbFile, StringUtil.LINE_TERMINATOR + string, mode == Mode.append);
        } else {
            FileUtil.writeString(wbFile, string, false);
        }
        LogMgr.logInfo(new CallerInfo(){}, "Successfully wrote message to file " + wbFile);
    }

    private static enum Mode {
        normal,
        append,
        prepend,
        log;


        static Mode byString(String string, Mode mode) {
            if (string != null && string.trim().length() > 0) {
                for (Mode mode2 : Mode.values()) {
                    if (!mode2.toString().equalsIgnoreCase(string)) continue;
                    return mode2;
                }
            }
            return mode;
        }
    }
}

