/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;

public class WbEnableOraOutput
extends SqlCommand {
    public static final String HIDE_HINT = "hide";
    public static final String VERB = "ENABLEOUT";
    public static final String PARAM_QUIET = "quiet";

    public WbEnableOraOutput() {
        this.cmdLine = new ArgumentParser(false);
        this.cmdLine.addArgument(PARAM_QUIET, ArgumentType.BoolSwitch);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        long l = -1L;
        this.cmdLine.parse(this.getCommandLine(string));
        String string2 = this.cmdLine.getNonArguments();
        if (StringUtil.isNonBlank(string2)) {
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                l = -1L;
            }
        }
        this.currentConnection.getMetadata().enableOutput(l);
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        if (this.cmdLine.getBoolean(PARAM_QUIET)) {
            this.runner.setSessionProperty("server_messages", HIDE_HINT);
            LogMgr.logDebug(new CallerInfo(){}, "Support for dbms_output enabled (limit=" + l + ")");
        } else {
            this.runner.removeSessionProperty("server_messages");
            statementRunnerResult.addMessage(ResourceMgr.getString("MsgDbmsOutputEnabled"));
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

