/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.WbManager;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.ControlFileFormat;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportType;
import workbench.db.exporter.InfinityLiterals;
import workbench.db.exporter.PoiHelper;
import workbench.db.exporter.RegexReplacingModifier;
import workbench.db.exporter.WrongFormatFileException;
import workbench.interfaces.ProgressReporter;
import workbench.interfaces.ResultSetConsumer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.sql.wbcommands.RegexModifierParameter;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.sql.wbcommands.WbXslt;
import workbench.storage.DataStore;
import workbench.storage.MergeGenerator;
import workbench.storage.RowActionMonitor;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CharacterEscapeType;
import workbench.util.CharacterRange;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.MemoryWatcher;
import workbench.util.QuoteEscapeType;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbExport
extends SqlCommand
implements RowActionMonitor,
ProgressReporter,
ResultSetConsumer {
    public static final String VERB = "WbExport";
    public static final String ARG_SOURCETABLE = "sourceTable";
    public static final String ARG_EXPORT_TYPE = "type";
    public static final String ARG_CREATE_OUTPUTDIR = "createDir";
    public static final String ARG_BLOB_TYPE = "blobType";
    public static final String ARG_XML_VERSION = "xmlVersion";
    public static final String ARG_ROWNUM = "rowNumberColumn";
    public static final String ARG_EMPTY_RESULTS = "writeEmptyResults";
    public static final String ARG_TABLE_PREFIX = "sourceTablePrefix";
    public static final String ARG_USE_CDATA = "useCDATA";
    public static final String ARG_USE_SCHEMA = "useSchema";
    public static final String ARG_FORMATFILE = "formatFile";
    public static final String ARG_COL_COMMENTS = "includeColumnComments";
    public static final String ARG_DISTRIBUTE_LOB_FILES = "lobsPerDirectory";
    public static final String ARG_QUOTE_ALWAYS = "quoteAlways";
    public static final String ARG_QUOTE_HEADER = "quoteHeader";
    public static final String ARG_QUOTE_NULL = "quoteNulls";
    public static final String ARG_APPEND = "append";
    public static final String ARG_CLOB_AS_FILE = "clobAsFile";
    public static final String ARG_CLOB_THRESHOLD = "clobFileThreshold";
    public static final String ARG_CONTINUE_ON_ERROR = "continueOnError";
    public static final String ARG_HEADER = "header";
    public static final String ARG_TABLEWHERE = "tableWhere";
    public static final String ARG_LOWERCASE_NAMES = "lowerCaseFilenames";
    public static final String ARG_ADD_INFOSHEET = "infoSheet";
    public static final String ARG_AUTOFILTER = "autoFilter";
    public static final String ARG_OPT_WIDTH = "autoColWidth";
    public static final String ARG_FIXED_HEADER = "fixedHeader";
    public static final String ARG_TARGET_SHEET_IDX = "targetSheet";
    public static final String ARG_TARGET_SHEET_NAME = "targetSheetName";
    public static final String ARG_DATA_OFFSET = "offset";
    public static final String ARG_PAGE_TITLE = "title";
    public static final String ARG_CHARFUNC = "charFunc";
    public static final String ARG_CONCAT_FUNCTION = "concatFunc";
    public static final String ARG_CONCAT_OPERATOR = "concat";
    public static final String ARG_CREATEFULL_HTML_PAGE = "createFullHTML";
    public static final String ARG_DATEFORMAT = "dateFormat";
    public static final String ARG_DECIMAL_SYMBOL = "decimal";
    public static final String ARG_DECIMAL_FORMAT = "decimalFormat";
    public static final String ARG_DECIMAL_GROUP = "decimalGroup";
    public static final String ARG_INTEGER_FORMAT = "integerFormat";
    public static final String ARG_MAX_DIGITS = "maxDigits";
    public static final String ARG_FIXED_DIGITS = "fixedDigits";
    public static final String ARG_ESCAPETEXT = "escapeText";
    public static final String ARG_ESCAPE_HTML = "escapeHTML";
    public static final String ARG_INCLUDE_CREATETABLE = "createTable";
    public static final String ARG_KEY_COLUMNS = "keyColumns";
    public static final String ARG_LINEENDING = "lineEnding";
    public static final String ARG_POSTDATA_HTML = "postDataHtml";
    public static final String ARG_PREDATA_HTML = "preDataHtml";
    public static final String ARG_SHOW_ENCODINGS = "showEncodings";
    public static final String ARG_TABLE = "table";
    public static final String ARG_TIMEFORMAT = "timeFormat";
    public static final String ARG_TIMESTAMP_FORMAT = "timestampFormat";
    public static final String ARG_INFINITY_LITERALS = "infinityLiterals";
    public static final String ARG_MERGE_TYPE = "mergeType";
    public static final String ARG_NULL_STRING = "nullString";
    public static final String ARG_TRIM_CHARDATA = "trimCharData";
    public static final String ARG_RETRIEVE_COLUMN_INFO = "retrieveColumnInfo";
    public static final String ARG_FNAME_COLUMN = "filenameColumn";
    public static final String ARG_EXTENSION_COLUMN = "extensionColumn";
    public static final String ARG_MULTI_ROW_INSERTS = "useMultiRowInserts";
    public static final String ARG_INCLUDE_IDENTITY = "includeAutoIncColumns";
    public static final String ARG_INCLUDE_READONLY = "includeReadOnlyColumns";
    private DataExporter exporter;
    private WbFile pendingOutput;
    private boolean consumeQuery;
    private boolean continueOnError;
    private String currentTable;
    private String defaultExtension;
    private boolean showProgress = true;
    private int progressInterval = 1;
    private final String exportTypes = "text,xml,sql,sqlinsert,sqlupdate,sqldeleteinsert,sqlmerge,sqldelete,ods,xlsm,html,xlsx,xls,json";

    public WbExport() {
        this.cmdLine = new ArgumentParser();
        CommonArgs.addDelimiterParameter(this.cmdLine);
        CommonArgs.addEncodingParameter(this.cmdLine);
        CommonArgs.addProgressParameter(this.cmdLine);
        CommonArgs.addCommitParameter(this.cmdLine);
        CommonArgs.addVerboseXmlParameter(this.cmdLine);
        CommonArgs.addQuoteEscaping(this.cmdLine);
        CommonArgs.addSqlDateLiteralParameter(this.cmdLine);
        this.cmdLine.addArgument(ARG_EXPORT_TYPE, StringUtil.stringToList("text,xml,sql,sqlinsert,sqlupdate,sqldeleteinsert,sqlmerge,sqldelete,ods,xlsm,html,xlsx,xls,json"));
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addArgument(ARG_LOWERCASE_NAMES, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_MULTI_ROW_INSERTS, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_TABLE_PREFIX);
        this.cmdLine.addArgument(ARG_PAGE_TITLE);
        this.cmdLine.addArgument("sheetName");
        this.cmdLine.addArgument(ARG_TABLE);
        this.cmdLine.addArgument("quotechar");
        this.cmdLine.addArgument(ARG_DATEFORMAT);
        this.cmdLine.addArgument(ARG_TIMESTAMP_FORMAT);
        this.cmdLine.addArgument("locale");
        this.cmdLine.addArgument(ARG_TIMEFORMAT);
        this.cmdLine.addArgument(ARG_DECIMAL_SYMBOL);
        this.cmdLine.addArgument(ARG_DECIMAL_FORMAT);
        this.cmdLine.addArgument(ARG_DECIMAL_GROUP);
        this.cmdLine.addArgument(ARG_INTEGER_FORMAT);
        this.cmdLine.addArgument(ARG_FIXED_DIGITS);
        this.cmdLine.addArgument(ARG_MAX_DIGITS);
        this.cmdLine.addArgument(ARG_CHARFUNC);
        this.cmdLine.addArgument(ARG_CONCAT_OPERATOR);
        this.cmdLine.addArgument(ARG_CONCAT_FUNCTION);
        this.cmdLine.addArgument(ARG_HEADER, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_CREATETABLE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_KEY_COLUMNS);
        this.cmdLine.addArgument(ARG_APPEND, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_XML_VERSION, StringUtil.stringToList("1.0", "1.1"));
        WbXslt.addCommonXsltParameters(this.cmdLine);
        this.cmdLine.addArgument("extension");
        this.cmdLine.addArgument(ARG_ESCAPE_HTML, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_CREATEFULL_HTML_PAGE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_PREDATA_HTML);
        this.cmdLine.addArgument(ARG_POSTDATA_HTML);
        this.cmdLine.addArgument(ARG_SOURCETABLE, ArgumentType.TableArgument);
        this.cmdLine.addArgument("schema", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument("outputDir", ArgumentType.DirName);
        this.cmdLine.addArgument(ARG_USE_CDATA, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_ESCAPETEXT, StringUtil.stringToList("control,7bit,8bit,extended,none,pgcopy"));
        this.cmdLine.addArgument(ARG_QUOTE_ALWAYS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_QUOTE_HEADER, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_QUOTE_NULL, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_LINEENDING, StringUtil.stringToList("crlf,lf"));
        this.cmdLine.addArgument(ARG_SHOW_ENCODINGS);
        this.cmdLine.addArgument(ARG_FORMATFILE, StringUtil.stringToList("postgres,oracle,sqlserver,db2,mysql"));
        this.cmdLine.addArgument("compress", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_EMPTY_RESULTS, ArgumentType.BoolArgument);
        this.cmdLine.addDeprecatedArgument("blobIdCols", ArgumentType.StringArgument);
        this.cmdLine.addArgument("lobIdCols");
        this.cmdLine.addArgument(ARG_FNAME_COLUMN);
        this.cmdLine.addArgument(ARG_BLOB_TYPE, BlobMode.getTypes());
        this.cmdLine.addArgument(ARG_CLOB_AS_FILE, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_CLOB_THRESHOLD);
        this.cmdLine.addArgument(ARG_CONTINUE_ON_ERROR, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_CREATE_OUTPUTDIR, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_ROWNUM);
        this.cmdLine.addArgument(ARG_TABLEWHERE);
        this.cmdLine.addArgument(ARG_RETRIEVE_COLUMN_INFO, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_ADD_INFOSHEET, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_OPT_WIDTH, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_AUTOFILTER, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_FIXED_HEADER, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_USE_SCHEMA, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_COL_COMMENTS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("ignoreOwner", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("excludeTables", ArgumentType.TableArgument);
        this.cmdLine.addArgument("types", ArgumentType.ObjectTypeArgument);
        this.cmdLine.addArgument(ARG_DISTRIBUTE_LOB_FILES, ArgumentType.IntegerArgument);
        this.cmdLine.addArgument(ARG_INFINITY_LITERALS, ArgumentType.ListArgument);
        this.cmdLine.addArgument(ARG_MERGE_TYPE, MergeGenerator.Factory.getSupportedTypes());
        this.cmdLine.addArgument(ARG_NULL_STRING);
        this.cmdLine.addArgument(ARG_TRIM_CHARDATA, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_TARGET_SHEET_IDX);
        this.cmdLine.addArgument(ARG_TARGET_SHEET_NAME);
        this.cmdLine.addArgument(ARG_DATA_OFFSET);
        this.cmdLine.addArgument(ARG_INCLUDE_IDENTITY, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_READONLY, ArgumentType.BoolArgument);
        RegexModifierParameter.addArguments(this.cmdLine);
        ConditionCheck.addParameters(this.cmdLine);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    private void addWrongArgumentsMessage(StatementRunnerResult statementRunnerResult) {
        if (WbManager.getInstance().isBatchMode()) {
            return;
        }
        String string = this.getWrongArgumentsMessage();
        statementRunnerResult.addMessageNewLine();
        statementRunnerResult.addMessage(string);
    }

    private String getWrongArgumentsMessage() {
        String string = ResourceMgr.getString("ErrExportWrongParameters");
        String string2 = "text=" + Boolean.toString(this.getHeaderDefault("text"));
        string2 = string2 + ", ods=" + Boolean.toString(this.getHeaderDefault("ods"));
        string2 = string2 + ", xls=" + Boolean.toString(this.getHeaderDefault("xls"));
        string2 = string2 + ", xlsx=" + Boolean.toString(this.getHeaderDefault("xlsx"));
        string2 = string2 + ", xlsm=" + Boolean.toString(this.getHeaderDefault("xlsm"));
        string = string.replace("%header_flag_default%", string2);
        string = string.replace("%verbose_default%", Boolean.toString(this.getVerboseXmlDefault()));
        string = string.replace("%date_literal_default%", Settings.getInstance().getDefaultExportDateLiteralType());
        string = string.replace("%default_encoding%", Settings.getInstance().getDefaultDataEncoding());
        string = string.replace("%xmlversion%", Settings.getInstance().getDefaultXmlVersion());
        string = string.replace("%empty_results_default%", Boolean.toString(Settings.getInstance().getDefaultWriteEmptyExports()));
        string = string.replace("%use_schema_default%", Boolean.toString(Settings.getInstance().getIncludeOwnerInSqlExport()));
        String string3 = "ods=" + Boolean.toString(this.getInfoSheetDefault("ods"));
        string3 = string3 + ", xls=" + Boolean.toString(this.getInfoSheetDefault("xls"));
        string3 = string3 + ", xlsx=" + Boolean.toString(this.getInfoSheetDefault("xlsx"));
        string3 = string3 + ", xlsm=" + Boolean.toString(this.getInfoSheetDefault("xlsm"));
        string = string.replace("%infosheet_defaults%", string3);
        string = string.replace("%types%", "text,xml,sql,sqlinsert,sqlupdate,sqldeleteinsert,sqlmerge,sqldelete,ods,xlsm,html,xlsx,xls,json");
        string = string.replace("%default_ts_format%", this.getTSFormatDefault());
        string = string.replace("%default_dt_format%", this.getDTFormatDefault());
        return string;
    }

    private String getTSFormatDefault() {
        return Settings.getInstance().getDefaultTimestampFormat();
    }

    private String getDTFormatDefault() {
        return Settings.getInstance().getDefaultDateFormat();
    }

    private boolean getInfoSheetDefault(String string) {
        return Settings.getInstance().getDefaultExportInfoSheet(string);
    }

    private boolean getVerboseXmlDefault() {
        return Settings.getInstance().getBoolProperty("workbench.export.xml.default.verbose", true);
    }

    private boolean getHeaderDefault(String string) {
        return Settings.getInstance().getBoolProperty("workbench.export." + string + ".default.header", false);
    }

    private boolean getIgnoreOwnerDefault() {
        return Settings.getInstance().getBoolProperty("workbench.export.default.ignoreowner", true);
    }

    @Override
    public boolean ignoreMaxRows() {
        return true;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        Object object2;
        String string2;
        Object object3;
        boolean bl;
        String string3;
        Object object4;
        boolean bl2;
        List<String> list;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(this.messageLogger);
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (this.cmdLine.isArgPresent(ARG_SHOW_ENCODINGS)) {
            String[] stringArray;
            statementRunnerResult.addMessageByKey("MsgAvailableEncodings");
            statementRunnerResult.addMessageNewLine();
            for (String string4 : stringArray = EncodingUtil.getEncodings()) {
                statementRunnerResult.addMessage(string4);
            }
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, this.getWrongArgumentsMessage());
            return statementRunnerResult;
        }
        if (!this.checkConditions(statementRunnerResult)) {
            return statementRunnerResult;
        }
        WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
        String string5 = this.cmdLine.getValue(ARG_EXPORT_TYPE);
        if (string5 == null) {
            string5 = this.findTypeFromFilename(wbFile);
        }
        if (string5 == null) {
            statementRunnerResult.addErrorMessageByKey("ErrExportTypeRequired");
            this.addWrongArgumentsMessage(statementRunnerResult);
            return statementRunnerResult;
        }
        if (string5.equals("sqlmerge")) {
            boolean bl3;
            boolean bl4 = bl3 = MergeGenerator.Factory.createGenerator(this.currentConnection) != null;
            if (!bl3) {
                statementRunnerResult.addErrorMessage("MERGE not supported for: " + this.currentConnection.getMetadata().getProductName());
                return statementRunnerResult;
            }
        }
        if ((string5.equals("xls") || string5.equals("xlsx")) && !PoiHelper.isPoiAvailable()) {
            statementRunnerResult.addErrorMessage(ResourceMgr.getString("ErrNoXLS"));
            statementRunnerResult.addMessageNewLine();
            statementRunnerResult.addMessageByKey("ErrExportUseXLSM");
            return statementRunnerResult;
        }
        if (string5.equals("xlsx") && !PoiHelper.isXLSXAvailable()) {
            statementRunnerResult.addErrorMessage(ResourceMgr.getString("ErrNoXLSX"));
            statementRunnerResult.addMessageNewLine();
            statementRunnerResult.addMessageByKey("ErrExportUseXLSM");
            return statementRunnerResult;
        }
        if (!this.isTypeValid(string5)) {
            statementRunnerResult.addErrorMessage(ResourceMgr.getString("ErrExportWrongType"));
            this.addWrongArgumentsMessage(statementRunnerResult);
            return statementRunnerResult;
        }
        if ("txt".equals(string5 = string5.trim().toLowerCase())) {
            string5 = "text";
        }
        if ("text".equals(string5) && !CommonArgs.checkQuoteEscapting(this.cmdLine)) {
            String string6 = ResourceMgr.getString("WarnQuoteAlwaysEscape") + "\n";
            LogMgr.logWarning(new CallerInfo(){}, string6, null);
            statementRunnerResult.addWarning(string6);
        }
        this.exporter = new DataExporter(this.currentConnection);
        if (this.cmdLine.isArgPresent(ARG_TRIM_CHARDATA)) {
            this.exporter.setTrimCharData(this.cmdLine.getBoolean(ARG_TRIM_CHARDATA, false));
        }
        String string7 = this.cmdLine.getValue(ARG_SOURCETABLE);
        WbFile wbFile2 = this.evaluateFileArgument(this.cmdLine.getValue("outputDir"));
        if (wbFile == null && wbFile2 == null) {
            statementRunnerResult.addErrorMessage(ResourceMgr.getString("ErrExportFileRequired"));
            this.addWrongArgumentsMessage(statementRunnerResult);
            return statementRunnerResult;
        }
        if (wbFile == null && wbFile2 != null && string7 == null) {
            statementRunnerResult.addErrorMessageByKey("ErrExportNoTablesDef");
            return statementRunnerResult;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet("html", "json", "xml", "xlsm", "ods");
        boolean bl5 = this.cmdLine.getBoolean(ARG_APPEND, false);
        if (bl5 && set.contains(string5)) {
            statementRunnerResult.addErrorMessageByKey("ErrNoAppend", string5);
            return statementRunnerResult;
        }
        if (this.cmdLine.isArgPresent(ARG_INFINITY_LITERALS)) {
            list = this.cmdLine.getListValue(ARG_INFINITY_LITERALS);
            if (list != null && list.size() == 2) {
                this.exporter.setInfinityLiterals(new InfinityLiterals((String)list.get(0), (String)list.get(1)));
            } else {
                statementRunnerResult.addWarning("Illegal infinity definition ignored");
            }
        }
        list = this.cmdLine.getValue(ARG_TABLE);
        String string8 = this.cmdLine.getValue("encoding");
        if (string8 != null) {
            this.exporter.setEncoding(string8);
        }
        this.exporter.setWriteEmptyResults(this.cmdLine.getBoolean(ARG_EMPTY_RESULTS, true));
        int n = this.cmdLine.getIntValue(ARG_CLOB_THRESHOLD, -1);
        this.exporter.setWriteClobAsFile(this.cmdLine.getBoolean(ARG_CLOB_AS_FILE, false), n);
        boolean bl6 = !Settings.getInstance().getGenerateInsertIgnoreIdentity();
        this.exporter.setIncludeIdentityCols(this.cmdLine.getBoolean(ARG_INCLUDE_IDENTITY, bl6));
        this.exporter.setIncludeReadOnlyCols(this.cmdLine.getBoolean(ARG_INCLUDE_READONLY, true));
        this.continueOnError = this.cmdLine.getBoolean(ARG_CONTINUE_ON_ERROR, false);
        this.exporter.setLocale(CommonArgs.getLocale(this.cmdLine, statementRunnerResult));
        String string9 = this.cmdLine.getValue(ARG_DATEFORMAT);
        if (string9 != null) {
            this.exporter.setDateFormat(string9);
        }
        if ((string9 = this.cmdLine.getValue(ARG_TIMESTAMP_FORMAT)) != null) {
            this.exporter.setTimestampFormat(string9);
        }
        if ((string9 = this.cmdLine.getValue(ARG_TIMEFORMAT)) != null) {
            this.exporter.setTimeFormat(string9);
        }
        String string10 = this.cmdLine.getValue(ARG_DECIMAL_FORMAT);
        String string11 = this.cmdLine.getValue(ARG_DECIMAL_SYMBOL);
        String string12 = this.cmdLine.getValue(ARG_DECIMAL_GROUP);
        if (StringUtil.isNonBlank(string10)) {
            this.exporter.setDecimalFormatString(string10, string11, string12);
        } else {
            int n2 = this.cmdLine.getIntValue(ARG_MAX_DIGITS, 0);
            bl2 = false;
            if (this.cmdLine.isArgPresent(ARG_MAX_DIGITS)) {
                bl2 = false;
            } else if (this.cmdLine.isArgPresent(ARG_FIXED_DIGITS)) {
                n2 = this.cmdLine.getIntValue(ARG_FIXED_DIGITS, -1);
                bl2 = true;
            }
            this.exporter.setDecimalDigits(n2, string11 == null ? "." : string11, bl2);
        }
        String string13 = this.cmdLine.getValue(ARG_INTEGER_FORMAT);
        this.exporter.setIntegerFormatString(string13, string11, string12);
        this.exporter.setAppendInfoSheet(this.cmdLine.getBoolean(ARG_ADD_INFOSHEET, Settings.getInstance().getDefaultExportInfoSheet(string5)));
        this.exporter.setTargetSheetIndex(this.cmdLine.getIntValue(ARG_TARGET_SHEET_IDX, -1));
        this.exporter.setTargetSheetName(this.cmdLine.getValue(ARG_TARGET_SHEET_NAME));
        bl2 = this.cmdLine.getIntValue(ARG_TARGET_SHEET_IDX, -1) < 0 && this.cmdLine.getValue(ARG_TARGET_SHEET_NAME) == null;
        this.exporter.setEnableAutoFilter(this.cmdLine.getBoolean(ARG_AUTOFILTER, bl2));
        this.exporter.setEnableFixedHeader(this.cmdLine.getBoolean(ARG_FIXED_HEADER, bl2));
        this.exporter.setOptimizeSpreadsheetColumns(this.cmdLine.getBoolean(ARG_OPT_WIDTH, bl2));
        this.exporter.setUseMultiRowInserts(this.cmdLine.getBoolean(ARG_MULTI_ROW_INSERTS, false));
        this.exporter.setExportHeaders(this.cmdLine.getBoolean(ARG_HEADER, this.getHeaderDefault(string5)));
        String string14 = this.cmdLine.getValue(ARG_PAGE_TITLE, this.cmdLine.getValue("sheetName"));
        this.exporter.setPageTitle(string14);
        this.exporter.setIncludeColumnComments(this.cmdLine.getBoolean(ARG_COL_COMMENTS, false));
        this.exporter.setSpreadSheetOffset(this.parseOffset(this.cmdLine.getValue(ARG_DATA_OFFSET)));
        RegexReplacingModifier regexReplacingModifier = RegexModifierParameter.buildFromCommandline(this.cmdLine);
        this.exporter.setDataModifier(regexReplacingModifier);
        String string15 = this.cmdLine.getValue(ARG_BLOB_TYPE);
        boolean bl7 = DataExporter.isContainerType(string5);
        BlobMode blobMode = BlobMode.getMode(string15);
        if (string15 != null && blobMode == null) {
            String string16 = StringUtil.listToString(BlobMode.getTypes(), ',');
            String string17 = ResourceMgr.getFormattedString("ErrExportInvalidBlobType", string15, string16);
            statementRunnerResult.addErrorMessage(string17);
            return statementRunnerResult;
        }
        if (blobMode == null) {
            blobMode = BlobMode.SaveToFile;
        }
        this.exporter.setBlobMode(blobMode);
        if (list != null) {
            this.exporter.setTableName((String)((Object)list));
        }
        if (this.cmdLine.isArgPresent(ARG_USE_SCHEMA)) {
            this.exporter.setUseSchemaInSql(this.cmdLine.getBoolean(ARG_USE_SCHEMA));
        }
        if ("text".equals(string5)) {
            boolean bl8;
            String string18;
            try {
                object4 = ControlFileFormat.parseCommandLine(this.cmdLine.getValue(ARG_FORMATFILE));
                this.exporter.addControlFileFormats((Set<ControlFileFormat>)object4);
            }
            catch (WrongFormatFileException wrongFormatFileException) {
                statementRunnerResult.addErrorMessageByKey("ErrExpWrongCtl", wrongFormatFileException.getFormat());
                return statementRunnerResult;
            }
            this.exporter.setNullString(this.cmdLine.getValue(ARG_NULL_STRING, null));
            object4 = this.cmdLine.getEscapedString("delimiter");
            if (object4 != null) {
                this.exporter.setTextDelimiter((String)object4);
            }
            if ((string3 = this.cmdLine.getEscapedString("quotechar")) != null) {
                this.exporter.setTextQuoteChar(string3);
            }
            if ((string18 = this.cmdLine.getValue(ARG_ESCAPETEXT)) != null) {
                if ("control".equalsIgnoreCase(string18) || "ctrl".equalsIgnoreCase(string18)) {
                    this.exporter.setEscapeRange(CharacterRange.RANGE_CONTROL);
                } else if ("7bit".equalsIgnoreCase(string18)) {
                    this.exporter.setEscapeRange(CharacterRange.RANGE_7BIT);
                } else if ("8bit".equalsIgnoreCase(string18) || "true".equalsIgnoreCase(string18)) {
                    this.exporter.setEscapeRange(CharacterRange.RANGE_8BIT);
                } else if ("extended".equalsIgnoreCase(string18)) {
                    this.exporter.setEscapeRange(CharacterRange.RANGE_8BIT_EXTENDED);
                } else if ("none".equalsIgnoreCase(string18) || "false".equalsIgnoreCase(string18)) {
                    this.exporter.setEscapeRange(null);
                } else if ("pgcopy".equalsIgnoreCase(string18)) {
                    this.exporter.setEscapeRange(CharacterRange.RANGE_CONTROL);
                    this.exporter.setEscapeType(CharacterEscapeType.pgHex);
                } else {
                    this.exporter.setEscapeRange(null);
                    String string19 = ResourceMgr.getString("ErrExportInvalidEscapeRangeIgnored").replace("%value%", string18);
                    statementRunnerResult.addMessage(string19);
                }
            }
            bl = this.cmdLine.getBoolean(ARG_QUOTE_ALWAYS);
            boolean bl9 = this.cmdLine.getBoolean(ARG_QUOTE_HEADER);
            boolean bl10 = this.cmdLine.getBoolean(ARG_QUOTE_NULL);
            object3 = CommonArgs.getQuoteEscaping(this.cmdLine);
            boolean bl11 = bl8 = bl || bl9 || bl10 || object3 != QuoteEscapeType.none;
            if (bl8 && StringUtil.isBlank(string3)) {
                statementRunnerResult.addErrorMessageByKey("ErrExpQuoteRequired");
                return statementRunnerResult;
            }
            this.exporter.setQuoteAlways(bl);
            this.exporter.setQuoteHeader(bl9);
            this.exporter.setQuoteNulls(bl10);
            this.exporter.setQuoteEscaping((QuoteEscapeType)((Object)object3));
            this.exporter.setRowIndexColumnName(this.cmdLine.getValue(ARG_ROWNUM));
            this.defaultExtension = ".txt";
        } else if (string5.startsWith("sql")) {
            Object object5;
            this.exporter.setIncludeCreateTable(this.cmdLine.getBoolean(ARG_INCLUDE_CREATETABLE));
            this.exporter.setChrFunction(this.cmdLine.getValue(ARG_CHARFUNC));
            this.exporter.setConcatFunction(this.cmdLine.getValue(ARG_CONCAT_FUNCTION));
            this.exporter.setConcatString(this.cmdLine.getValue(ARG_CONCAT_OPERATOR));
            object4 = this.cmdLine.getValue(ARG_MERGE_TYPE);
            if (StringUtil.isBlank((CharSequence)object4)) {
                object4 = this.currentConnection.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(this.currentConnection, "9.5") ? "postgres-9.5" : this.currentConnection.getDbId();
            }
            this.exporter.setMergeType((String)object4);
            CommonArgs.setCommitEvery(this.exporter, this.cmdLine);
            string3 = this.cmdLine.getValue(ARG_KEY_COLUMNS);
            if (string3 != null) {
                object5 = StringUtil.stringToList(string3, ",");
                this.exporter.setKeyColumnsToUse((List<String>)object5);
            }
            this.defaultExtension = ".sql";
            object5 = this.cmdLine.getValue("sqlDateLiterals");
            if (object5 != null) {
                this.exporter.setDateLiteralType((String)object5);
            }
        } else if ("xml".equals(string5)) {
            object4 = this.cmdLine.getValue("stylesheet");
            string3 = this.cmdLine.getValue("xsltOutput");
            boolean bl12 = this.getVerboseXmlDefault();
            bl = this.cmdLine.getBoolean("verboseXML", bl12);
            this.exporter.setUseVerboseFormat(bl);
            String string20 = this.cmdLine.getValue(ARG_XML_VERSION);
            if (string20 != null) {
                this.exporter.setXMLVersion(string20);
            }
            if (object4 != null && string3 != null) {
                Map<String, String> map = WbXslt.getParameters(this.cmdLine);
                object3 = this.findXsltFile((String)object4);
                if (((File)object3).exists()) {
                    this.exporter.setXsltTransformation((String)object4);
                    this.exporter.setXsltTransformationOutput(string3);
                    this.exporter.setXsltParameters(map);
                } else {
                    String string21 = ResourceMgr.getFormattedString("ErrXsltNotFound", ((File)object3).getAbsolutePath());
                    statementRunnerResult.addMessage(string21);
                }
            }
            this.exporter.setUseCDATA(this.cmdLine.getBoolean(ARG_USE_CDATA));
            this.defaultExtension = ".xml";
            if (string8 == null) {
                this.exporter.setEncoding("UTF-8");
            }
        } else if ("xlsm".equals(string5)) {
            this.defaultExtension = ".xml";
            if (string8 == null) {
                this.exporter.setEncoding("UTF-8");
            }
        } else if ("html".equals(string5)) {
            object4 = this.cmdLine.getValue(ARG_ESCAPE_HTML);
            if (object4 != null) {
                this.exporter.setEscapeHtml("true".equalsIgnoreCase((String)object4));
            }
            if ((object4 = this.cmdLine.getValue(ARG_CREATEFULL_HTML_PAGE)) != null) {
                this.exporter.setCreateFullHtmlPage("true".equalsIgnoreCase((String)object4));
            }
            this.exporter.setHtmlHeading(this.cmdLine.getValue(ARG_PREDATA_HTML));
            this.exporter.setHtmlTrailer(this.cmdLine.getValue(ARG_POSTDATA_HTML));
            this.defaultExtension = ".html";
        } else if ("json".equals(string5)) {
            this.exporter.setNullString(this.cmdLine.getValue(ARG_NULL_STRING, null));
            this.defaultExtension = ".json";
        } else {
            this.defaultExtension = "." + string5.toLowerCase();
        }
        object4 = this.cmdLine.getValue("extension", null);
        if (StringUtil.isNonBlank((CharSequence)object4)) {
            this.defaultExtension = object4;
        }
        this.exporter.setAppendToFile(bl5);
        string3 = this.cmdLine.getValue(ARG_LINEENDING);
        if (string3 != null) {
            if ("crlf".equalsIgnoreCase(string3) || "dos".equalsIgnoreCase(string3) || "win".equalsIgnoreCase(string3) || "\\r\\n".equals(string3)) {
                this.exporter.setLineEnding("\r\n");
            } else if ("lf".equalsIgnoreCase(string3) || "unix".equalsIgnoreCase(string3) || "linux".equalsIgnoreCase(string3) || "\\n".equals(string3)) {
                this.exporter.setLineEnding("\n");
            }
        }
        if ((string2 = this.cmdLine.getValue("lobidcols")) == null && (string2 = this.cmdLine.getValue("blobidcols")) != null) {
            statementRunnerResult.addWarning("The blobIdCols parameter is deprecated, please use lobIdCols");
        }
        List<String> list2 = StringUtil.stringToList(string2, ",", true, true, false);
        this.exporter.setBlobIdColumns(list2);
        if (this.cmdLine.isArgPresent(ARG_DISTRIBUTE_LOB_FILES)) {
            this.exporter.setMaxLobFilesPerDirectory(this.cmdLine.getIntValue(ARG_DISTRIBUTE_LOB_FILES, -1));
        }
        this.exporter.setCompressOutput(this.cmdLine.getBoolean("compress", false));
        this.setExportType(this.exporter, string5);
        List<TableIdentifier> list3 = null;
        try {
            String string22 = this.cmdLine.getValue("excludeTables");
            object3 = this.cmdLine.getValue("schema");
            object2 = SourceTableArgument.parseTypes(this.cmdLine.getValue("types"), this.currentConnection);
            SourceTableArgument sourceTableArgument = new SourceTableArgument(string7, string22, (String)object3, (String[])object2, this.currentConnection);
            list3 = sourceTableArgument.getTables();
            if (list3.isEmpty() && this.cmdLine.isArgPresent(ARG_SOURCETABLE)) {
                String string23 = "ErrTableNotFound";
                if (sourceTableArgument.wasWildcardArgument()) {
                    string23 = "ErrExportNoTablesFound";
                }
                statementRunnerResult.addErrorMessageByKey(string23, string7);
                return statementRunnerResult;
            }
            if (this.cmdLine.isArgPresent(ARG_SOURCETABLE)) {
                LogMgr.logDebug(new CallerInfo(){}, "Exporting tables: " + StringUtil.listToString(list3, ','));
            }
            if (CollectionUtil.isNonEmpty(object = sourceTableArgument.getMissingTables())) {
                String string24 = StringUtil.listToString(object, ',');
                String string25 = ResourceMgr.getString("MsgTablesNotFound") + " " + string24;
                statementRunnerResult.addWarning(string25);
                statementRunnerResult.addMessageNewLine();
                LogMgr.logWarning(new CallerInfo(){}, "The following tables were not found: " + string24);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve table list", sQLException);
            statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(sQLException));
            return statementRunnerResult;
        }
        if (this.isCancelled) {
            statementRunnerResult.addWarningByKey("MsgExportCancelled");
            return statementRunnerResult;
        }
        this.consumeQuery = list3.isEmpty();
        CommonArgs.setProgressInterval(this, this.cmdLine);
        this.showProgress = this.progressInterval > 0;
        boolean bl13 = this.cmdLine.getBoolean(ARG_CREATE_OUTPUTDIR, false);
        if (bl13) {
            object3 = null;
            if (wbFile != null) {
                object3 = new WbFile(wbFile.getAbsoluteFile().getParentFile());
            } else if (wbFile2 != null) {
                object3 = wbFile2;
            }
            if (object3 != null && !((File)object3).exists()) {
                if (!((File)object3).mkdirs()) {
                    statementRunnerResult.addErrorMessageByKey("ErrCreateDir", ((WbFile)object3).getFullPath());
                    return statementRunnerResult;
                }
                statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgDirCreated", ((WbFile)object3).getFullPath()));
            }
        }
        if (wbFile2 != null && !wbFile2.exists()) {
            statementRunnerResult.addErrorMessageByKey("ErrOutputDirNotFound", wbFile2.getFullPath());
            return statementRunnerResult;
        }
        if (wbFile != null) {
            this.exporter.setFilenameColumn(this.cmdLine.getValue(ARG_FNAME_COLUMN));
            boolean bl14 = true;
            object2 = null;
            try {
                if (wbFile.exists()) {
                    object2 = ResourceMgr.getString("ErrExportFileWrite");
                    bl14 = wbFile.canWrite();
                } else {
                    wbFile.tryCreate();
                }
            }
            catch (IOException iOException) {
                bl14 = false;
                object2 = ResourceMgr.getFormattedString("ErrFileCreate", iOException.getMessage());
            }
            if (!bl14) {
                statementRunnerResult.addErrorMessage((String)object2);
                return statementRunnerResult;
            }
        }
        this.exporter.prepareExport();
        this.exporter.setContinueOnError(this.continueOnError);
        this.exporter.setRowMonitor(this);
        this.exporter.setReportInterval(this.progressInterval);
        if (this.consumeQuery) {
            this.exporter.setRowMonitor(this.rowMonitor);
            this.exporter.setReportInterval(this.progressInterval);
            this.runner.setConsumer(this);
            if (wbFile != null) {
                this.pendingOutput = wbFile;
            } else if (wbFile2 != null) {
                this.pendingOutput = wbFile2;
            }
            String string26 = ResourceMgr.getString("MsgSpoolInit");
            string26 = string26.replace("%type%", this.exporter.getTypeDisplay());
            object2 = null;
            if (wbFile != null) {
                object2 = wbFile.getFullPath();
            } else if (wbFile2 != null) {
                object2 = wbFile2.getFullPath();
            }
            string26 = string26.replace("%file%", (CharSequence)object2);
            statementRunnerResult.addMessage(string26);
        } else {
            boolean bl15 = this.cmdLine.getBoolean("ignoreOwner", this.getIgnoreOwnerDefault());
            boolean bl16 = this.cmdLine.getBoolean(ARG_RETRIEVE_COLUMN_INFO, this.currentConnection.getDbSettings().useColumnListInExport());
            boolean bl17 = this.cmdLine.getBoolean(ARG_LOWERCASE_NAMES, true);
            object = this.cmdLine.getValue(ARG_TABLEWHERE);
            try {
                if (list3.size() > 1 || wbFile2 != null) {
                    this.exportTableList(list3, statementRunnerResult, wbFile2, wbFile, this.cmdLine.getValue(ARG_TABLE_PREFIX), (String)object, bl15, bl7, bl16, bl17);
                } else {
                    this.exportSingleTable(list3.get(0), statementRunnerResult, wbFile, (String)object, bl16);
                }
                this.addMessages(statementRunnerResult);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when running table export", exception);
                this.addErrorInfo(statementRunnerResult, string, exception);
            }
        }
        long l = MemoryWatcher.getFreeMemory();
        System.gc();
        long l2 = MemoryWatcher.getFreeMemory();
        LogMgr.logDebug(new CallerInfo(){}, "Memory before GC: " + l + ", after GC: " + l2);
        return statementRunnerResult;
    }

    private Point parseOffset(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        if (string.indexOf(44) > -1) {
            String[] stringArray = string.trim().split(",");
            if (stringArray == null || stringArray.length != 2) {
                return null;
            }
            int n = StringUtil.getIntValue(stringArray[0], -1);
            int n2 = StringUtil.getIntValue(stringArray[1], -1);
            if (n < 1 || n2 < 1) {
                return null;
            }
            return new Point(n - 1, n2 - 1);
        }
        return PoiHelper.excelToNumbers(string);
    }

    boolean isTypeValid(String string) {
        if (string == null) {
            return false;
        }
        return this.cmdLine.isAllowedValue(ARG_EXPORT_TYPE, string);
    }

    private void setExportType(DataExporter dataExporter, String string) {
        ExportType exportType = ExportType.getExportType(string);
        dataExporter.setOutputType(exportType);
    }

    private void exportSingleTable(TableIdentifier tableIdentifier, StatementRunnerResult statementRunnerResult, WbFile wbFile, String string, boolean bl) throws SQLException {
        if (bl) {
            this.exporter.addTableExportJob(wbFile, tableIdentifier, string);
        } else {
            String string2 = "SELECT * FROM " + tableIdentifier.getTableExpression(this.currentConnection);
            this.exporter.addQueryJob(string2, wbFile, string);
        }
        this.exporter.runJobs();
        if (this.exporter.isSuccess()) {
            long l = this.exporter.getTotalRows();
            String string3 = ResourceMgr.getString("MsgExportTableExported");
            string3 = string3.replace("%file%", this.exporter.getFullOutputFilename());
            string3 = string3.replace("%tablename%", tableIdentifier.getTableExpression());
            string3 = string3.replace("%rows%", Long.toString(l));
            statementRunnerResult.addMessage(string3);
        } else {
            statementRunnerResult.setFailure();
        }
    }

    private void exportTableList(List<TableIdentifier> list, StatementRunnerResult statementRunnerResult, File file, File file2, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        statementRunnerResult.setSuccess();
        int n = list.size();
        if (bl2) {
            this.exporter.setAppendToFile(true);
            this.exporter.setPageTitle(null);
            if (file2 != null && file2.exists()) {
                file2.delete();
            }
        } else {
            if (file == null) {
                statementRunnerResult.addErrorMessageByKey("ErrExportOutputDirRequired");
                return;
            }
            if (!file.exists()) {
                statementRunnerResult.addErrorMessageByKey("ErrOutputDirNotFound", file.getAbsolutePath());
                return;
            }
            if (!file.isDirectory()) {
                statementRunnerResult.addErrorMessageByKey("ErrExportOutputDirNotDir", file.getAbsolutePath());
                return;
            }
        }
        if (bl3) {
            bl3 = StringUtil.isBlank(string);
        }
        if (string == null) {
            string = "";
        }
        for (TableIdentifier tableIdentifier : list) {
            String string3 = StringUtil.makeFilename(bl ? tableIdentifier.getTableName() : tableIdentifier.getTableExpression(), bl4);
            WbFile wbFile = null;
            wbFile = file == null ? new WbFile(file2) : new WbFile(file, string3 + this.defaultExtension);
            try {
                if (bl3) {
                    this.exporter.addTableExportJob(wbFile, tableIdentifier, string2);
                    continue;
                }
                String string4 = "SELECT * FROM " + string + tableIdentifier.getTableExpression(this.currentConnection);
                this.exporter.addQueryJob(string4, wbFile, string2);
            }
            catch (SQLException sQLException) {
                if (this.continueOnError) {
                    statementRunnerResult.addWarning(ResourceMgr.getString("TxtWarning") + ": " + sQLException.getMessage());
                    continue;
                }
                throw sQLException;
            }
        }
        this.exporter.runJobs();
        if (this.exporter.isSuccess()) {
            n = this.exporter.getNumberExportedTables();
            Object object = ResourceMgr.getString("MsgExportNumTables");
            object = ((String)object).replace("%numtables%", Integer.toString(n));
            object = file == null ? ((String)object).replace("%dir%", file2.getAbsolutePath()) : ((String)object).replace("%dir%", file.getAbsolutePath());
            statementRunnerResult.addMessage((CharSequence)object);
            statementRunnerResult.setSuccess();
        } else {
            statementRunnerResult.setFailure();
        }
    }

    private void addMessages(StatementRunnerResult statementRunnerResult) {
        CharSequence charSequence = this.exporter.getErrors();
        if (StringUtil.isNonEmpty(charSequence)) {
            statementRunnerResult.addMessage(charSequence);
        }
        if (this.exporter.hasWarning()) {
            statementRunnerResult.addMessageByKey("TxtWarnings");
            statementRunnerResult.addMessage(this.exporter.getWarnings());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeResult(StatementRunnerResult statementRunnerResult) {
        if (!statementRunnerResult.isSuccess()) {
            return;
        }
        try {
            long l = 0L;
            if (statementRunnerResult.hasResultSets()) {
                String string = statementRunnerResult.getSourceCommand();
                ResultSet resultSet = statementRunnerResult.getResultSets().get(0);
                statementRunnerResult.getResultSets().remove(0);
                l = this.exporter.exportResultSet(this.pendingOutput, resultSet, string);
            } else if (statementRunnerResult.hasDataStores() && this.pendingOutput != null) {
                l = this.exportDataStores(statementRunnerResult.getDataStores());
            }
            if (this.exporter.isSuccess()) {
                statementRunnerResult.addMessageNewLine();
                statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgSpoolOk", Long.toString(l)));
                statementRunnerResult.addMessage(ResourceMgr.getString("MsgSpoolTarget") + " " + this.exporter.getFullOutputFilename());
            }
            this.addMessages(statementRunnerResult);
            if (this.exporter.isSuccess()) {
                statementRunnerResult.setSuccess();
            } else {
                statementRunnerResult.setFailure();
            }
        }
        catch (Exception exception) {
            statementRunnerResult.addMessageByKey("ErrExportExecute");
            statementRunnerResult.addErrorMessage(ExceptionUtil.getAllExceptions(exception).toString());
            LogMgr.logError(new CallerInfo(){}, "Error exporting data", exception);
        }
        finally {
            statementRunnerResult.setConsumed(true);
            statementRunnerResult.clearResultData();
            this.exporter.finished();
            this.runner.setConsumer(null);
        }
    }

    private long exportDataStores(List<DataStore> list) throws Exception {
        if (this.pendingOutput == null) {
            return 0L;
        }
        if (list == null || list.isEmpty()) {
            return 0L;
        }
        long l = 0L;
        boolean bl = this.exporter.isContainerExport();
        boolean bl2 = !this.pendingOutput.isDirectory();
        this.exporter.setAppendToFile(bl);
        File file = this.pendingOutput.isDirectory() ? this.pendingOutput : this.pendingOutput.getParentFile();
        for (int i = 0; i < list.size(); ++i) {
            DataStore dataStore = list.get(i);
            this.exporter.setPageTitle(dataStore.getResultName());
            WbFile wbFile = null;
            if (bl2 || bl) {
                wbFile = this.pendingOutput;
            } else {
                String string = dataStore.getResultName();
                if (string == null) {
                    string = "export_result_" + Integer.toString(i + 1);
                }
                wbFile = new WbFile(file, StringUtil.makeFilename(string) + this.defaultExtension);
            }
            l += this.exporter.startExport(wbFile, dataStore, null);
        }
        return l;
    }

    @Override
    public void done() {
        super.done();
        if (this.exporter != null) {
            this.exporter.finished();
        }
        this.exporter = null;
        this.maxRows = 0;
        this.consumeQuery = false;
        this.currentTable = null;
        this.defaultExtension = null;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.exporter != null) {
            this.exporter.cancelExecution();
        }
        super.cancel();
    }

    @Override
    public void jobFinished() {
    }

    @Override
    public void setCurrentObject(String string, long l, long l2) {
        this.currentTable = string;
        if (!this.showProgress && this.rowMonitor != null) {
            this.rowMonitor.setCurrentObject(this.currentTable, -1L, -1L);
        }
    }

    @Override
    public void setCurrentRow(long l, long l2) {
        if (this.showProgress && this.rowMonitor != null) {
            this.rowMonitor.setCurrentObject(this.currentTable, l, -1L);
        }
    }

    @Override
    public void setReportInterval(int n) {
        this.progressInterval = n;
    }

    @Override
    public int getMonitorType() {
        return 7;
    }

    @Override
    public void setMonitorType(int n) {
    }

    @Override
    public void saveCurrentType(String string) {
    }

    @Override
    public void restoreType(String string) {
    }

    protected String findTypeFromFilename(WbFile wbFile) {
        if (wbFile == null) {
            return null;
        }
        String string = wbFile.getFullPath().toLowerCase();
        if (string.endsWith(".txt")) {
            return "text";
        }
        if (string.endsWith(".xml")) {
            return "xml";
        }
        if (string.endsWith(".text")) {
            return "text";
        }
        if (string.endsWith(".csv")) {
            return "text";
        }
        if (string.endsWith(".htm")) {
            return "html";
        }
        if (string.endsWith(".html")) {
            return "html";
        }
        if (string.endsWith(".sql")) {
            return "sqlinsert";
        }
        if (string.endsWith(".xls")) {
            return "xls";
        }
        if (string.endsWith(".xlsm")) {
            return "xlsm";
        }
        if (string.endsWith(".xlsx")) {
            return "xlsx";
        }
        if (string.endsWith(".ods")) {
            return "ods";
        }
        if (string.endsWith(".json")) {
            return "json";
        }
        return null;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

