/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;

public class WbFeedback
extends SqlCommand {
    public static final String VERB = "WbFeedback";
    private final String command;

    public WbFeedback() {
        this(VERB);
    }

    public WbFeedback(String string) {
        this.command = string;
        this.cmdLine = new ArgumentParser(false);
        this.cmdLine.addArgument("on", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("off", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("quiet", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("traceon", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("traceoff", ArgumentType.BoolSwitch);
    }

    @Override
    public String getVerb() {
        return this.command;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        statementRunnerResult.setSuccess();
        this.cmdLine.parse(this.getCommandLine(string));
        boolean bl = this.cmdLine.getBoolean("quiet");
        if (this.cmdLine.getBoolean("off")) {
            this.runner.setVerboseLogging(false);
            if (bl) {
                LogMgr.logInfo(new CallerInfo(){}, "Feedback disabled");
            } else {
                statementRunnerResult.addMessageByKey("MsgFeedbackDisabled");
            }
        } else if (this.cmdLine.getBoolean("on")) {
            this.runner.setVerboseLogging(true);
            if (bl) {
                LogMgr.logInfo(new CallerInfo(){}, "Feedback enabled");
            } else {
                statementRunnerResult.addMessageByKey("MsgFeedbackEnabled");
            }
        } else if (this.cmdLine.getBoolean("traceon")) {
            statementRunnerResult.setSuccess();
            this.runner.setTraceStatements(true);
            if (!bl) {
                statementRunnerResult.addMessageByKey("MsgTraceOn");
            }
        } else if (this.cmdLine.getBoolean("traceoff")) {
            statementRunnerResult.setSuccess();
            this.runner.setTraceStatements(false);
            if (!bl) {
                statementRunnerResult.addMessageByKey("MsgTraceOff");
            }
        } else if (this.cmdLine.hasUnknownArguments()) {
            statementRunnerResult.addErrorMessageByKey("ErrFeedbackWrongParameter");
        } else {
            if (this.runner.getVerboseLogging()) {
                statementRunnerResult.addMessageByKey("MsgFeedbackEnabled");
            } else {
                statementRunnerResult.addMessageByKey("MsgFeedbackDisabled");
            }
            statementRunnerResult.setSuccess();
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

