/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import workbench.db.DropScriptGenerator;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.WbFile;

public class WbGenDrop
extends SqlCommand {
    public static final String VERB = "WbGenerateDrop";
    public static final String PARAM_INCLUDE_CREATE = "includeCreate";
    public static final String PARAM_DROP_FK_ONLY = "onlyForeignkeys";
    public static final String PARAM_SORT_BY_TYPE = "sortByType";
    public static final String PARAM_INCLUDE_COMMENTS = "includeMarkers";

    public WbGenDrop() {
        this.isUpdatingCommand = true;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("outputDir", ArgumentType.DirName);
        this.cmdLine.addArgument("outputFile", ArgumentType.Filename);
        this.cmdLine.addArgument("tables", ArgumentType.TableArgument);
        this.cmdLine.addArgument(PARAM_INCLUDE_CREATE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_DROP_FK_ONLY, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_SORT_BY_TYPE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_INCLUDE_COMMENTS, ArgumentType.BoolArgument);
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrGenDropWrongParam"));
            return statementRunnerResult;
        }
        if (!this.cmdLine.hasArguments()) {
            statementRunnerResult.addErrorMessageByKey("ErrGenDropWrongParam");
            return statementRunnerResult;
        }
        SourceTableArgument sourceTableArgument = new SourceTableArgument(this.cmdLine.getValue("tables"), this.currentConnection);
        List<TableIdentifier> list = sourceTableArgument.getTables();
        if (list.isEmpty()) {
            statementRunnerResult.addErrorMessageByKey("ErrExportNoTablesFound", this.cmdLine.getValue("tables"));
            return statementRunnerResult;
        }
        boolean bl = this.cmdLine.getBoolean(PARAM_INCLUDE_CREATE, true);
        boolean bl2 = this.cmdLine.getBoolean(PARAM_DROP_FK_ONLY, false);
        boolean bl3 = this.cmdLine.getBoolean(PARAM_SORT_BY_TYPE, true);
        boolean bl4 = this.cmdLine.getBoolean(PARAM_INCLUDE_COMMENTS, false);
        DropScriptGenerator dropScriptGenerator = new DropScriptGenerator(this.currentConnection);
        dropScriptGenerator.setIncludeRecreateStatements(bl);
        dropScriptGenerator.setIncludeComments(bl4);
        if (bl2) {
            dropScriptGenerator.setIncludeRecreateStatements(false);
            dropScriptGenerator.setIncludeDropTable(false);
        }
        dropScriptGenerator.setTables(list);
        dropScriptGenerator.setSortByType(bl3);
        dropScriptGenerator.setRowMonitor(this.rowMonitor);
        String string3 = this.cmdLine.getValue("outputDir", null);
        String string4 = this.cmdLine.getValue("outputFile", null);
        dropScriptGenerator.generateScript();
        List<TableIdentifier> list2 = dropScriptGenerator.getTables();
        if (string3 != null) {
            WbFile wbFile = new WbFile(string3);
            if (!wbFile.isDirectory()) {
                statementRunnerResult.addErrorMessageByKey("ErrExportOutputDirNotDir", string3);
                return statementRunnerResult;
            }
            int n = 0;
            for (TableIdentifier tableIdentifier : list2) {
                WbFile wbFile2 = new WbFile(wbFile, "drop_" + tableIdentifier.getTableName().toLowerCase() + ".sql");
                try {
                    FileUtil.writeString(wbFile2, dropScriptGenerator.getScriptFor(tableIdentifier));
                    ++n;
                }
                catch (IOException iOException) {
                    statementRunnerResult.addErrorMessageByKey("ErrFileCreate", ExceptionUtil.getDisplay(iOException));
                    return statementRunnerResult;
                }
            }
            statementRunnerResult.setSuccess();
            statementRunnerResult.addMessageByKey("MsgDropScriptsWritten", n, wbFile.getFullPath());
        } else if (string4 != null) {
            WbFile wbFile = new WbFile(string4);
            try {
                FileUtil.writeString(wbFile, dropScriptGenerator.getScript());
                statementRunnerResult.addMessageByKey("MsgScriptWritten", wbFile.getFullPath());
                statementRunnerResult.setSuccess();
            }
            catch (IOException iOException) {
                statementRunnerResult.addErrorMessageByKey("ErrFileCreate", ExceptionUtil.getDisplay(iOException));
            }
        } else {
            statementRunnerResult.setSuccess();
            statementRunnerResult.addMessage(dropScriptGenerator.getScript());
        }
        return statementRunnerResult;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
    }

    @Override
    public boolean isUpdatingCommand(WbConnection wbConnection, String string) {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

