/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ObjectScripter;
import workbench.db.TableIdentifier;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringBuilderOutput;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbGenerateFKScript
extends SqlCommand
implements ScriptGenerationMonitor {
    public static final String VERB = "WbGenerateFKScript";
    private ObjectScripter scripter;

    public WbGenerateFKScript() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("tables", ArgumentType.TableArgument);
        this.cmdLine.addArgument("excludeTables", ArgumentType.TableArgument);
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        CommonArgs.addEncodingParameter(this.cmdLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult;
        block13: {
            StringBuilderOutput stringBuilderOutput;
            block14: {
                statementRunnerResult = new StatementRunnerResult();
                String string2 = this.getCommandLine(string);
                this.cmdLine.parse(string2);
                if (this.displayHelp(statementRunnerResult)) {
                    return statementRunnerResult;
                }
                String string3 = this.cmdLine.getValue("tables");
                String string4 = this.cmdLine.getValue("excludeTables");
                if (StringUtil.isBlank(string3)) {
                    string3 = "%";
                }
                String[] stringArray = this.currentConnection.getMetadata().getTableTypesArray();
                SourceTableArgument sourceTableArgument = new SourceTableArgument(string3, string4, null, stringArray, this.currentConnection);
                List<TableIdentifier> list = sourceTableArgument.getTables();
                WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
                this.scripter = new ObjectScripter(list, this.currentConnection);
                this.scripter.setUseSeparator(this.cmdLine.getBoolean("useSeparator", false));
                if (this.rowMonitor != null) {
                    this.rowMonitor.saveCurrentType(VERB);
                    this.rowMonitor.setMonitorType(5);
                }
                this.scripter.setProgressMonitor(this);
                stringBuilderOutput = new StringBuilderOutput(list.size() * 100);
                this.scripter.setTextOutput(stringBuilderOutput);
                try {
                    this.scripter.generateForeignKeys();
                }
                finally {
                    if (this.rowMonitor != null) {
                        this.rowMonitor.restoreType(VERB);
                        this.rowMonitor.jobFinished();
                    }
                }
                if (this.isCancelled) {
                    statementRunnerResult.setWarning();
                    return statementRunnerResult;
                }
                statementRunnerResult.setSuccess();
                if (wbFile == null) break block14;
                String string5 = this.cmdLine.getValue("encoding", EncodingUtil.getDefaultEncoding());
                Writer writer = null;
                try {
                    writer = EncodingUtil.createWriter(wbFile, string5, false);
                    writer.write(stringBuilderOutput.toString());
                    statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgScriptWritten", wbFile.getAbsolutePath()));
                }
                catch (IOException iOException) {
                    try {
                        LogMgr.logError(new CallerInfo(){}, "Could not write outputfile", iOException);
                        statementRunnerResult.setFailure();
                        statementRunnerResult.addMessage(iOException.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        FileUtil.closeQuietely(writer);
                        throw throwable;
                    }
                    FileUtil.closeQuietely(writer);
                    break block13;
                }
                FileUtil.closeQuietely(writer);
                break block13;
            }
            statementRunnerResult.addMessage(stringBuilderOutput.toString());
        }
        return statementRunnerResult;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.scripter != null) {
            this.scripter.cancel();
        }
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public void done() {
        this.scripter = null;
    }

    @Override
    public void setCurrentObject(String string, int n, int n2) {
        if (this.rowMonitor != null) {
            this.rowMonitor.setCurrentObject(string, n, n2);
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

