/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import workbench.db.DbObject;
import workbench.db.ObjectScripter;
import workbench.db.TriggerDefinition;
import workbench.db.TriggerReaderFactory;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.interfaces.TextOutput;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.ResourceMgr;
import workbench.sql.DelimiterDefinition;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringBuilderOutput;
import workbench.util.StringUtil;

public class WbGenerateScript
extends SqlCommand
implements ScriptGenerationMonitor {
    public static final String VERB = "WbGenerateScript";
    public static final String SHORT_VERB = "WbGenScript";
    public static final String ARG_EXCLUDE = "exclude";
    public static final String ARG_INCLUDE_FK = "includeForeignkeys";
    public static final String ARG_INCLUDE_DROP = "includeDrop";
    public static final String ARG_INCLUDE_COMMIT = "includeCommit";
    public static final String ARG_USE_SEPARATOR = "useSeparator";
    public static final String ARG_STMT_DELIMITER = "statementDelimiter";
    private ObjectScripter scripter;

    public WbGenerateScript() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("types", ArgumentType.ObjectTypeArgument);
        this.cmdLine.addArgument("schemas", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument("catalog", ArgumentType.CatalogArgument);
        this.cmdLine.addArgument("objects", ArgumentType.TableArgument);
        this.cmdLine.addArgument(ARG_EXCLUDE);
        this.cmdLine.addArgument("includeProcedures", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("includeTriggers", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("includeTableGrants", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_USE_SEPARATOR, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_INCLUDE_FK, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addArgument(ARG_INCLUDE_DROP, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_INCLUDE_COMMIT, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_STMT_DELIMITER, DelimiterDefinition.ABBREVIATIONS);
        CommonArgs.addEncodingParameter(this.cmdLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        List<String> list2 = null;
        String string3 = null;
        Collection<String> collection = null;
        String string4 = null;
        if (!this.cmdLine.hasArguments()) {
            string4 = string2;
        } else {
            if (this.cmdLine.hasUnknownArguments()) {
                this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrGenScriptWrongParam"));
                return statementRunnerResult;
            }
            string4 = this.cmdLine.getValue("objects");
            list2 = this.cmdLine.getListValue("schemas");
            string3 = this.cmdLine.getValue("catalog");
            collection = this.cmdLine.getListValue("types");
        }
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        if (CollectionUtil.isEmpty(list2)) {
            list2 = CollectionUtil.arrayList(this.currentConnection.getCurrentSchema());
        }
        String string5 = this.cmdLine.getValue(ARG_EXCLUDE);
        if (CollectionUtil.isEmpty(collection)) {
            collection = this.currentConnection.getMetadata().getObjectTypes();
        }
        String[] stringArray = StringUtil.toArray(collection, true, true);
        for (String list3 : list2) {
            object5 = new SourceTableArgument(string4, string5, list3, stringArray, this.currentConnection);
            arrayList.addAll(((SourceTableArgument)object5).getTables());
        }
        boolean bl = this.currentConnection.getDbSettings().schemaIsCatalog();
        List<String> list = this.getSearchNames("includeProcedures");
        if (list != null) {
            object5 = this.currentConnection.getMetadata().getProcedureReader();
            for (String string6 : list2) {
                if (this.isCancelled) break;
                String string7 = bl ? string6 : string3;
                object4 = bl ? null : string6;
                for (String string8 : list) {
                    object3 = object5.getProcedureList(string7, (String)object4, string8);
                    arrayList.addAll((Collection<DbObject>)object3);
                }
            }
        }
        if ((object5 = this.getSearchNames("includeTriggers")) != null) {
            object2 = TriggerReaderFactory.createReader(this.currentConnection);
            for (String string9 : list2) {
                if (this.isCancelled) break;
                object4 = bl ? string9 : string3;
                object = bl ? null : string9;
                Iterator iterator = object5.iterator();
                while (iterator.hasNext()) {
                    object3 = (String)iterator.next();
                    List<TriggerDefinition> list3 = object2.getTriggerList((String)object4, (String)object, (String)object3);
                    arrayList.addAll(list3);
                }
            }
        }
        if (this.isCancelled) {
            statementRunnerResult.setWarning();
            return statementRunnerResult;
        }
        object2 = this.evaluateFileArgument(this.cmdLine.getValue("file"));
        this.scripter = new ObjectScripter(arrayList, this.currentConnection);
        this.scripter.setUseSeparator(this.cmdLine.getBoolean(ARG_USE_SEPARATOR, DbExplorerSettings.getGenerateScriptSeparator()));
        this.scripter.setIncludeDrop(this.cmdLine.getBoolean(ARG_INCLUDE_DROP, false));
        this.scripter.setIncludeGrants(this.cmdLine.getBoolean("includeTableGrants", true));
        this.scripter.setIncludeForeignKeys(this.cmdLine.getBoolean(ARG_INCLUDE_FK, true));
        this.scripter.setIncludeCommit(this.cmdLine.getBoolean(ARG_INCLUDE_COMMIT, true));
        String string10 = this.cmdLine.getValue(ARG_STMT_DELIMITER);
        DelimiterDefinition delimiterDefinition = DelimiterDefinition.parseCmdLineArgument(string10);
        this.scripter.setDelimiterToUse(delimiterDefinition);
        if (this.rowMonitor != null) {
            this.rowMonitor.saveCurrentType(VERB);
            this.rowMonitor.setMonitorType(5);
        }
        this.scripter.setProgressMonitor(this);
        object4 = new StringBuilderOutput(arrayList.size() * 250);
        this.scripter.setTextOutput((TextOutput)object4);
        try {
            this.scripter.generateScript();
        }
        finally {
            if (this.rowMonitor != null) {
                this.rowMonitor.restoreType(VERB);
                this.rowMonitor.jobFinished();
            }
        }
        if (this.isCancelled) {
            statementRunnerResult.setWarning();
            return statementRunnerResult;
        }
        statementRunnerResult.setSuccess();
        if (object2 != null) {
            try {
                object = this.cmdLine.getValue("encoding", EncodingUtil.getDefaultEncoding());
                FileUtil.writeString((File)object2, ((StringBuilderOutput)object4).toString(), (String)object, false);
                statementRunnerResult.addMessageByKey("MsgScriptWritten", ((File)object2).getAbsolutePath());
            }
            catch (IOException iOException) {
                LogMgr.logError(new CallerInfo(){}, "Could not write outputfile", iOException);
                statementRunnerResult.setFailure();
                statementRunnerResult.addMessage(iOException.getLocalizedMessage());
            }
        } else {
            statementRunnerResult.addMessage(((StringBuilderOutput)object4).toString());
        }
        return statementRunnerResult;
    }

    private List<String> getSearchNames(String string) {
        List<String> list = null;
        String string2 = this.cmdLine.getValue(string, null);
        if (StringUtil.isBoolean(string2) && StringUtil.stringToBool(string2)) {
            list = CollectionUtil.arrayList("*");
        } else if (string2 != null) {
            list = StringUtil.stringToList(string2, ",", true, true, false, false);
        }
        return list;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.scripter != null) {
            this.scripter.cancel();
        }
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return SHORT_VERB;
    }

    @Override
    public void done() {
        this.scripter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentObject(String string, int n, int n2) {
        if (this.rowMonitor != null) {
            if (string.indexOf(32) > -1) {
                try {
                    this.rowMonitor.saveCurrentType("gen2");
                    this.rowMonitor.setMonitorType(7);
                    this.rowMonitor.setCurrentObject(string, n, n2);
                }
                finally {
                    this.rowMonitor.restoreType("gen2");
                }
            } else {
                this.rowMonitor.setCurrentObject(string, n, n2);
            }
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

