/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.Collection;
import java.util.ResourceBundle;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.ResourcePath;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;

public class WbHelp
extends SqlCommand {
    public static final String VERB = "WbHelp";

    public WbHelp() {
        this.isUpdatingCommand = false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        Collection<String> collection = this.runner.getAllWbCommands();
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 25);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("language/cmdhelp", Settings.getInstance().getLanguage());
        collection.remove("DESC");
        collection.add("DESCRIBE");
        collection.remove("ENABLEOUT");
        collection.remove("DISABLEOUT");
        collection.remove("SHOW");
        for (String string2 : collection) {
            stringBuffer.append(string2);
            try {
                String string3 = resourceBundle.getString(string2);
                stringBuffer.append(" - ");
                stringBuffer.append(string3);
            }
            catch (Exception exception) {
                String string4 = ResourceMgr.getString(ResourcePath.EXTENSION, string2, false);
                if (string4 != null && !string4.equals(string2)) {
                    stringBuffer.append(" - (extension) ");
                    stringBuffer.append(string4);
                }
                LogMgr.logWarning(new CallerInfo(){}, "Error getting command short help from ResourceBundle", exception);
            }
            stringBuffer.append('\n');
        }
        statementRunnerResult.addMessage(stringBuffer);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

