/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import workbench.WbManager;
import workbench.interfaces.SqlHistoryProvider;
import workbench.resource.GuiSettings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.annotations.ScrollAnnotation;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class WbHistory
extends SqlCommand {
    public static final String VERB = "WbHistory";
    public static final String SHORT_VERB = "WbHist";
    private int maxLength = -1;

    public WbHistory() {
        this.isUpdatingCommand = false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    public void setMaxDisplayLength(int n) {
        this.maxLength = n;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        String string2;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        SqlHistoryProvider sqlHistoryProvider = this.runner.getHistoryProvider();
        List<Object> list = Collections.emptyList();
        if (sqlHistoryProvider != null) {
            list = sqlHistoryProvider.getHistoryEntries();
        }
        if (StringUtil.isNonBlank(string2 = this.getCommandLine(string))) {
            return statementRunnerResult;
        }
        DataStore dataStore = new DataStore(new String[]{"NR", "SQL"}, new int[]{4, 12}, new int[]{5, GuiSettings.getMultiLineThreshold()});
        int n = 1;
        for (String string3 : list) {
            int n2 = dataStore.addRow();
            dataStore.setValue(n2, 0, (Object)n);
            dataStore.setValue(n2, 1, (Object)this.getDisplayString(string3));
            ++n;
        }
        dataStore.resetStatus();
        dataStore.setResultName(VERB);
        dataStore.setGeneratingSql(ScrollAnnotation.getScrollToEndAnnotation() + "\n" + VERB);
        statementRunnerResult.addDataStore(dataStore);
        return statementRunnerResult;
    }

    private String getDisplayString(String string) {
        if (WbManager.getInstance().isGUIMode()) {
            return string;
        }
        String string2 = SqlUtil.makeCleanSql(string, false, false, true, this.currentConnection);
        if (this.maxLength > -1) {
            string2 = StringUtil.getMaxSubstring(string2, this.maxLength - 10);
        }
        return string2;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

