/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class WbIsolationLevel
extends SqlCommand {
    public static final String VERB = "WbIsolationLevel";
    private final Map<String, Integer> levelMap = new TreeMap<String, Integer>(CaseInsensitiveComparator.INSTANCE);

    public WbIsolationLevel() {
        this.levelMap.put("read_committed", 2);
        this.levelMap.put("read_uncommitted", 1);
        this.levelMap.put("serializable", 8);
        this.levelMap.put("repeatable_read", 4);
        this.levelMap.put("none", 0);
        this.cmdLine = new ArgumentParser(false);
        for (String string : this.levelMap.keySet()) {
            this.cmdLine.addArgument(string);
        }
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        if (StringUtil.isBlank(string2)) {
            String string3 = this.currentConnection.getIsolationLevelName();
            statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgLevelCurrent", string3));
            statementRunnerResult.setSuccess();
            return statementRunnerResult;
        }
        int n = this.stringToLevel(string2);
        if (n == -1) {
            statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgLevelUnknown", string2));
            statementRunnerResult.setFailure();
        } else {
            try {
                boolean bl = this.currentConnection.getSqlConnection().getMetaData().supportsTransactionIsolationLevel(n);
                this.currentConnection.getSqlConnection().setTransactionIsolation(n);
                statementRunnerResult.setSuccess();
                statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgLevelChanged", this.currentConnection.getIsolationLevelName()));
                if (!bl) {
                    statementRunnerResult.addWarning(ResourceMgr.getFormattedString("MsgLevelNotSupported", SqlUtil.getIsolationLevelName(n)));
                }
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Could not set isolation level", sQLException);
                statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgLevelChangeError", sQLException.getMessage()));
                statementRunnerResult.setFailure();
            }
        }
        return statementRunnerResult;
    }

    protected int stringToLevel(String string) {
        string = string.trim();
        string = string.replaceAll("\\s+", " ");
        Integer n = this.levelMap.get(string = string.replaceAll(" ", "_"));
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

