/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class WbListSchemas
extends SqlCommand {
    public static final String VERB = "WbListSchemas";

    public WbListSchemas() {
        this.isUpdatingCommand = false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        ConsoleSettings.getInstance().setNextRowDisplay(RowDisplay.SingleLine);
        List<String> list = this.currentConnection.getMetadata().getSchemas();
        DataStore dataStore = null;
        if (this.currentConnection.getMetadata().isPostgres()) {
            dataStore = this.listPgSchemas();
        } else {
            String string2 = StringUtil.capitalize(this.currentConnection.getMetadata().getSchemaTerm());
            String[] stringArray = new String[]{string2};
            int[] nArray = new int[]{12};
            int[] nArray2 = new int[]{10};
            dataStore = new DataStore(stringArray, nArray, nArray2);
            for (String string3 : list) {
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)string3);
            }
        }
        dataStore.setResultName(ResourceMgr.getString("TxtSchemaList"));
        dataStore.setGeneratingSql(VERB);
        dataStore.resetStatus();
        statementRunnerResult.addDataStore(dataStore);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    private DataStore listPgSchemas() {
        String string = "SELECT n.nspname AS \"Schema\",\n       pg_catalog.pg_get_userbyid(n.nspowner) AS \"Owner\", \n       pg_catalog.array_to_string(n.nspacl, ', ') as \"Access privileges\",        pg_catalog.obj_description(n.oid, 'pg_namespace') AS \"Description\" FROM pg_catalog.pg_namespace n\nWHERE n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'\nORDER BY 1";
        DataStore dataStore = SqlUtil.getResult(this.currentConnection, string, true);
        dataStore.setGeneratingSql(string);
        return dataStore;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

