/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.sql.SQLException;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.PkMapping;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbLoadPkMapping
extends SqlCommand {
    public static final String VERB = "WbLoadPKMap";

    public WbLoadPkMapping() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("file", ArgumentType.Filename);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        String string3 = this.cmdLine.getValue("file");
        if (string3 == null) {
            string3 = Settings.getInstance().getPKMappingFilename();
        } else {
            object = new WbFile(Settings.getInstance().getConfigDir());
            string3 = StringUtil.replace(string3, "%ConfigDir%", ((WbFile)object).getFullPath());
        }
        if (string3 == null) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrPkDefNoFile");
            return statementRunnerResult;
        }
        PkMapping.getInstance().loadMapping(string3);
        object = ResourceMgr.getString("MsgPkMappingLoaded");
        File file = new File(string3);
        object = StringUtil.replace((String)object, "%filename%", file.getAbsolutePath());
        statementRunnerResult.addMessage((CharSequence)object);
        statementRunnerResult.addMessageNewLine();
        String string4 = PkMapping.getInstance().getMappingAsText();
        if (string4 != null) {
            statementRunnerResult.addMessage(string4);
            statementRunnerResult.addMessageByKey("MsgPkDefinitionsEnd");
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

