/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import workbench.db.TableGrantReader;
import workbench.db.TableIdentifier;
import workbench.db.ViewGrantReader;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbObjectGrants
extends SqlCommand {
    public static final String VERB = "WbObjectGrants";

    public WbObjectGrants() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("tables", ArgumentType.TableArgument);
        this.cmdLine.addArgument("views", ArgumentType.ViewArgument);
        this.cmdLine.addArgument("outputDir", ArgumentType.DirName);
        this.cmdLine.addArgument("outputFile", ArgumentType.Filename);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StringBuilder stringBuilder;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(this.messageLogger);
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (!this.cmdLine.hasArguments()) {
            statementRunnerResult.addErrorMessageByKey("ErrObjectGrantsWrongParam");
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrObjectGrantsWrongParam"));
            return statementRunnerResult;
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(7);
            this.rowMonitor.setCurrentObject(ResourceMgr.getString("MsgRetrievingTables"), -1L, -1L);
        }
        SourceTableArgument sourceTableArgument = new SourceTableArgument(this.cmdLine.getValue("tables"), this.currentConnection);
        List<TableIdentifier> list = sourceTableArgument.getTables();
        List<String> list2 = sourceTableArgument.getMissingTables();
        String[] stringArray = new String[]{this.currentConnection.getMetadata().getViewTypeName()};
        SourceTableArgument sourceTableArgument2 = new SourceTableArgument(this.cmdLine.getValue("views"), null, null, stringArray, this.currentConnection);
        List<TableIdentifier> list3 = sourceTableArgument2.getTables();
        list2.addAll(sourceTableArgument2.getMissingTables());
        if (list2.size() > 0) {
            for (String charSequence2 : list2) {
                statementRunnerResult.addWarning(ResourceMgr.getFormattedString("ErrTableNotFound", charSequence2));
            }
            statementRunnerResult.addMessageNewLine();
            if (list.isEmpty()) {
                statementRunnerResult.setFailure();
                return statementRunnerResult;
            }
        }
        TableGrantReader tableGrantReader = TableGrantReader.createReader(this.currentConnection);
        StringBuilder stringBuilder2 = new StringBuilder(list.size() * 50);
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(6);
        }
        ViewGrantReader viewGrantReader = ViewGrantReader.createViewGrantReader(this.currentConnection);
        int n = list.size() + list3.size();
        int n2 = 1;
        for (TableIdentifier tableIdentifier : list) {
            if (this.rowMonitor != null) {
                this.rowMonitor.setCurrentObject(tableIdentifier.getTableExpression(), n2, n);
            }
            if (StringUtil.isNonBlank(stringBuilder = tableGrantReader.getTableGrantSource(this.currentConnection, tableIdentifier))) {
                stringBuilder2.append((CharSequence)stringBuilder);
            }
            ++n2;
        }
        Object object = list3.iterator();
        while (object.hasNext()) {
            TableIdentifier tableIdentifier = object.next();
            if (this.rowMonitor != null) {
                this.rowMonitor.setCurrentObject(tableIdentifier.getTableExpression(), n2, n);
            }
            if (StringUtil.isNonBlank(stringBuilder = viewGrantReader.getViewGrantSource(this.currentConnection, tableIdentifier))) {
                stringBuilder2.append((CharSequence)stringBuilder);
            }
            ++n2;
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
        if ((object = this.cmdLine.getValue("outputFile", null)) == null) {
            statementRunnerResult.addMessage(stringBuilder2);
        } else {
            WbFile wbFile = new WbFile((String)object);
            try {
                FileUtil.writeString(wbFile, stringBuilder2.toString());
                statementRunnerResult.addMessageByKey("MsgScriptWritten", wbFile.getFullPath());
                statementRunnerResult.setSuccess();
            }
            catch (IOException iOException) {
                statementRunnerResult.addErrorMessageByKey("ErrFileCreate", ExceptionUtil.getDisplay(iOException));
            }
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

