/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.JdbcUtils;
import workbench.db.oracle.OracleErrorInformationReader;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.ErrorDescriptor;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.storage.DataStore;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.DdlObjectInfo;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class WbOraShow
extends SqlCommand {
    public static final String VERB = "SHOW";
    private final long ONE_KB = 1024L;
    private final long ONE_MB = 0x100000L;
    private final Set<String> types = CollectionUtil.caseInsensitiveSet("FUNCTION", "PROCEDURE", "PACKAGE", "PACKAGE BODY", "TRIGGER", "VIEW", "TYPE", "TYPE BODY", "DIMENSION", "JAVA SOURCE", "JAVA CLASS");
    private Map<String, String> propertyUnits = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);

    public WbOraShow() {
        this.propertyUnits.put("result_cache_max_size", "kb");
        this.propertyUnits.put("sga_max_size", "mb");
        this.propertyUnits.put("sga_target", "mb");
        this.propertyUnits.put("memory_max_target", "mb");
        this.propertyUnits.put("memory_target", "mb");
        this.propertyUnits.put("db_recovery_file_dest_size", "mb");
        this.propertyUnits.put("db_recycle_cache_size", "mb");
        this.propertyUnits.put("db_cache_size", "mb");
        this.propertyUnits.put("result_cache_max_size", "mb");
        this.propertyUnits.put("java_pool_size", "mb");
        this.propertyUnits.put("pga_aggregate_target", "mb");
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        String string2 = this.getCommandLine(string);
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string2);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            statementRunnerResult.addErrorMessage(this.getErrorMessage());
            return statementRunnerResult;
        }
        String string3 = sQLToken.getText().toLowerCase();
        if (string3.startsWith("parameter")) {
            SQLToken sQLToken2 = sQLLexer.getNextToken(false, false);
            String string4 = null;
            if (sQLToken2 != null) {
                string4 = string2.substring(sQLToken2.getCharBegin());
            }
            return this.getParameterValues(string4, false);
        }
        if (string3.startsWith("spparameter")) {
            SQLToken sQLToken3 = sQLLexer.getNextToken(false, false);
            String string5 = null;
            if (sQLToken3 != null) {
                string5 = string2.substring(sQLToken3.getCharBegin());
            }
            return this.getParameterValues(string5, true);
        }
        if (string3.equals("sga")) {
            return this.getSGAInfo(true);
        }
        if (string3.equals("sgainfo")) {
            return this.getSGAInfo(false);
        }
        if (string3.equals("logsource")) {
            return this.getLogSource();
        }
        if (string3.equals("recyclebin")) {
            return this.showRecycleBin();
        }
        if (string3.equals("user")) {
            statementRunnerResult.addMessage("USER is " + this.currentConnection.getCurrentUser());
        } else {
            if (string3.equals("appinfo")) {
                return this.getAppInfo(string);
            }
            if (string3.equals("autocommit")) {
                if (this.currentConnection.getAutoCommit()) {
                    statementRunnerResult.addMessage("autocommit ON");
                } else {
                    statementRunnerResult.addMessage("autocommit OFF");
                }
            } else {
                if (string3.startsWith("error")) {
                    return this.getErrors(sQLLexer, string);
                }
                if (string3.equals("release") || string3.equals("version")) {
                    return this.showVersion();
                }
                if (string3.equals("edition")) {
                    return this.showUserEnv("SESSION_EDITION_NAME", "EDITION");
                }
                if (string3.equals("pdbs") && JdbcUtils.hasMinimumServerVersion(this.currentConnection, "12.0")) {
                    return this.showPdbs();
                }
                if (string3.startsWith("con_") && JdbcUtils.hasMinimumServerVersion(this.currentConnection, "12.0")) {
                    return this.showUserEnv(string3);
                }
                statementRunnerResult.addMessage(this.getErrorMessage());
                statementRunnerResult.setFailure();
            }
        }
        return statementRunnerResult;
    }

    private String getErrorMessage() {
        String string = ResourceMgr.getString("ErrOraShow");
        if (JdbcUtils.hasMinimumServerVersion(this.currentConnection, "12.1")) {
            string = string + "\n- pdbs\n- con_name\n- con_id";
        }
        return string;
    }

    private StatementRunnerResult showUserEnv(String string) {
        return this.showUserEnv(string, string);
    }

    private StatementRunnerResult showVersion() {
        String string = JdbcUtils.hasMinimumServerVersion(this.currentConnection, "18.0") ? "select version_full from product_component_version where upper(product) like 'ORACLE%'" : "select version from product_component_version where upper(product) like 'ORACLE%'";
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult("SHOW release");
        DataStore dataStore = SqlUtil.getResult(this.currentConnection, string);
        if (dataStore.getRowCount() > 0) {
            statementRunnerResult.addMessage("Release " + dataStore.getValueAsString(0, 0));
        } else {
            statementRunnerResult.addMessage(this.currentConnection.getDatabaseProductVersion());
        }
        return statementRunnerResult;
    }

    private StatementRunnerResult showUserEnv(String string, String string2) {
        String string3 = "select sys_context('userenv', '" + string.toUpperCase() + "') as " + string2 + " from dual";
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult("SHOW " + string);
        try {
            DataStore dataStore = SqlUtil.getResultData(this.currentConnection, string3, false);
            dataStore.setResultName(string2.toUpperCase());
            statementRunnerResult.addDataStore(dataStore);
        }
        catch (Exception exception) {
            statementRunnerResult.addErrorMessage(exception.getMessage());
        }
        return statementRunnerResult;
    }

    private StatementRunnerResult showPdbs() {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult("SHOW pdbs");
        try {
            DataStore dataStore = OracleUtils.getPDBs(this.currentConnection);
            dataStore.setResultName("PDBS");
            statementRunnerResult.addDataStore(dataStore);
        }
        catch (SQLException sQLException) {
            statementRunnerResult.addErrorMessage(sQLException.getMessage());
        }
        return statementRunnerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementRunnerResult showRecycleBin() {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult("SHOW RECYCLEBIN");
        statementRunnerResult.ignoreUpdateCounts(true);
        String string = "SELECT original_name as \"ORIGINAL NAME\", \n       object_name as \"RECYCLEBIN NAME\", \n       type as \"OBJECT TYPE\", \n       droptime as \"DROP TIME\" \nFROM user_recyclebin \nWHERE can_undrop = 'YES' \nORDER BY original_name, \n         droptime desc, \n         object_name";
        ResultSet resultSet = null;
        try {
            this.currentStatement = this.currentConnection.createStatementForQuery();
            resultSet = this.currentStatement.executeQuery(string);
            this.processResults(statementRunnerResult, true, resultSet);
            if (statementRunnerResult.hasDataStores() && statementRunnerResult.getDataStores().get(0).getRowCount() == 0) {
                statementRunnerResult.clear();
                statementRunnerResult.addMessageByKey("MsgRecyclebinEmpty");
            }
            statementRunnerResult.setSuccess();
        }
        catch (SQLException sQLException) {
            try {
                statementRunnerResult.addErrorMessage(sQLException.getMessage());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, this.currentStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, this.currentStatement);
        }
        JdbcUtils.closeAll(resultSet, this.currentStatement);
        return statementRunnerResult;
    }

    private StatementRunnerResult getErrors(SQLLexer sQLLexer, String string) {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        String string2 = null;
        Object object2 = null;
        String string3 = null;
        if (sQLToken != null && this.types.contains(sQLToken.getText())) {
            string3 = sQLToken.getContents();
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        if (sQLToken != null) {
            object = sQLToken.getText();
            int n = ((String)object).indexOf(46);
            if (n > 0) {
                string2 = ((String)object).substring(0, n - 1);
                object2 = ((String)object).substring(n);
            } else {
                object2 = object;
            }
        }
        if (object2 == null && (object = this.currentConnection.getLastDdlObjectInfo()) != null) {
            object2 = ((DdlObjectInfo)object).getObjectName();
            string3 = ((DdlObjectInfo)object).getObjectType();
        }
        object = null;
        if (object2 != null) {
            OracleErrorInformationReader oracleErrorInformationReader = new OracleErrorInformationReader(this.currentConnection);
            object = oracleErrorInformationReader.getErrorInfo(null, string2, (String)object2, string3, true);
        }
        if (object != null) {
            statementRunnerResult.addMessage(((ErrorDescriptor)object).getErrorMessage());
        } else {
            statementRunnerResult.addMessageByKey("TxtOraNoErr");
        }
        return statementRunnerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementRunnerResult getAppInfo(String string) {
        StatementRunnerResult statementRunnerResult;
        ResultSet resultSet;
        Statement statement;
        block5: {
            String string2 = "SELECT module FROM v$session WHERE audsid = USERENV('SESSIONID')";
            statement = null;
            resultSet = null;
            statementRunnerResult = new StatementRunnerResult(string);
            try {
                statement = this.currentConnection.createStatementForQuery();
                resultSet = statement.executeQuery(string2);
                if (!resultSet.next()) break block5;
                String string3 = resultSet.getString(1);
                if (string3 == null) {
                    statementRunnerResult.addMessage("appinfo is OFF");
                    break block5;
                }
                statementRunnerResult.addMessage("appinfo is \"" + string3 + "\"");
            }
            catch (SQLException sQLException) {
                try {
                    statementRunnerResult.addErrorMessage(sQLException.getMessage());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return statementRunnerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementRunnerResult getParameterValues(String string, boolean bl) {
        StatementRunnerResult statementRunnerResult;
        ResultSet resultSet;
        block10: {
            String string2;
            boolean bl2 = JdbcUtils.hasMinimumServerVersion(this.currentConnection, "10.0");
            boolean bl3 = Settings.getInstance().getBoolProperty("workbench.db.oracle.showparameter.display_value", bl2);
            int n = 0;
            int n2 = 2;
            if (bl) {
                string2 = "select sid, \n       name,  \n       type,  \n       display_value as value, \n       update_comment \nfrom v$spparameter \n";
                n = 0;
                n2 = 2;
            } else {
                string2 = "select name,  \n       case type \n         when 1 then 'boolean'  \n         when 2 then 'string' \n         when 3 then 'integer' \n         when 4 then 'parameter file' \n         when 5 then 'reserved' \n         when 6 then 'big integer' \n         else to_char(type) \n       end as type,  \n       " + (bl3 ? "display_value" : "value") + " as value, \n       description, \n       update_comment \nfrom v$parameter \n ";
            }
            resultSet = null;
            List<String> list = StringUtil.stringToList(string, ",", true, true, false, false);
            if (list.size() > 0) {
                string2 = string2 + "where";
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        string2 = string2 + "  or";
                    }
                    string2 = string2 + " name like lower('%" + list.get(i) + "%') \n";
                }
            }
            string2 = string2 + "order by name";
            statementRunnerResult = new StatementRunnerResult(string2);
            statementRunnerResult.ignoreUpdateCounts(true);
            LogMgr.logMetadataSql(new CallerInfo(){}, "system parameters", string2, new Object[0]);
            try {
                this.currentStatement = this.currentConnection.createStatementForQuery();
                resultSet = this.currentStatement.executeQuery(string2);
                this.processResults(statementRunnerResult, true, resultSet);
                if (!statementRunnerResult.hasDataStores()) break block10;
                DataStore dataStore = statementRunnerResult.getDataStores().get(0);
                for (int i = 0; i < dataStore.getRowCount(); ++i) {
                    String string3;
                    String string4 = dataStore.getValueAsString(i, n);
                    String string5 = dataStore.getValueAsString(i, n2);
                    if (bl3 || (string3 = this.formatMemorySize(string4, string5)) == null) continue;
                    dataStore.setValue(i, 2, (Object)string3);
                }
                dataStore.resetStatus();
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "system parameters", string2, new Object[0]);
                    statementRunnerResult.addErrorMessage(sQLException.getMessage());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, this.currentStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, this.currentStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, this.currentStatement);
        return statementRunnerResult;
    }

    public static final List<String> getOptions() {
        return CollectionUtil.arrayList("appinfo", "autocommit", "con_id", "con_name", "edition", "error", "logsource", "parameters", "pdbs", "recyclebin", "sga", "sgainfo", "spparameters", "user", "release");
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    protected String formatMemorySize(String string, String string2) {
        String string3 = this.propertyUnits.get(string);
        if (string3 == null) {
            return null;
        }
        try {
            long l = Long.valueOf(string2);
            if (l == 0L) {
                return null;
            }
            if ("kb".equals(string3)) {
                return Long.toString(this.roundToKb(l)) + "K";
            }
            if ("mb".equals(string3)) {
                return Long.toString(this.roundToMb(l)) + "M";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatementRunnerResult getLogSource() {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string = "SELECT destination \nFROM v$archive_dest \n WHERE status = 'VALID'";
        Statement statement = null;
        ResultSet resultSet = null;
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(new CallerInfo(){}, "Retrieving log source information using:\n" + string);
        }
        try {
            statement = this.currentConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            DataStore dataStore = new DataStore(new String[]{"LOGSOURCE", "VALUE"}, new int[]{12, 12});
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if ("USE_DB_RECOVERY_FILE_DEST".equals(string2)) {
                    string2 = "";
                }
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)"LOGSOURCE");
                dataStore.setValue(n, 1, (Object)string2);
            }
            dataStore.setGeneratingSql("-- show logsource\n" + string);
            dataStore.setResultName("LOGSOURCE");
            dataStore.resetStatus();
            statementRunnerResult.addDataStore(dataStore);
            statementRunnerResult.setSuccess();
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve log information using: " + string, sQLException);
                statementRunnerResult.addErrorMessage(sQLException.getMessage());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return statementRunnerResult;
    }

    protected StatementRunnerResult getSGAInfo(boolean bl) {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string = null;
        string = bl ? "SELECT 'Total System Global Area' as \"Memory\", \n       sum(value) as \"Value\", \n       'bytes' as unit \nFROM v$sga \nUNION ALL \nSELECT name, \n       value, \n       'bytes' \nFROM v$sga" : "SELECT *\nFROM v$sgainfo";
        LogMgr.logMetadataSql(new CallerInfo(){}, "SGA info", string, new Object[0]);
        try {
            DataStore dataStore = SqlUtil.getResultData(this.currentConnection, string, false);
            dataStore.setGeneratingSql(string);
            dataStore.setResultName("SGA Size");
            statementRunnerResult.addDataStore(dataStore);
            statementRunnerResult.setSuccess();
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "SGA info", string, new Object[0]);
            statementRunnerResult.addErrorMessage(sQLException.getMessage());
        }
        return statementRunnerResult;
    }

    private long roundToKb(long l) {
        if (l < 1024L) {
            return l;
        }
        return l / 1024L;
    }

    private long roundToMb(long l) {
        if (l < 0x100000L) {
            return l;
        }
        return l / 0x100000L;
    }
}

