/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.WbManager;
import workbench.console.ConsoleSettings;
import workbench.interfaces.ResultSetConsumer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.BatchRunner;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.storage.DataStore;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;

public class WbRunResult
extends SqlCommand
implements ResultSetConsumer {
    public static final String ARG_DRY_RUN = "dryRun";
    public static final String ARG_QUERY = "query";
    public static final String VERB = "WbRunResult";
    private BatchRunner batchRunner;
    private boolean dryRun = false;

    public WbRunResult() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("continueOnError", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("showProgress", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("displayResult", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("verbose", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("printStatements", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("showTiming", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_DRY_RUN, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_QUERY);
        ConditionCheck.addParameters(this.cmdLine);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (!this.checkConditions(statementRunnerResult)) {
            return statementRunnerResult;
        }
        boolean bl = Settings.getInstance().useNonStandardQuoteEscaping(this.currentConnection);
        boolean bl2 = Settings.getInstance().getWbIncludeDefaultContinue();
        boolean bl3 = this.cmdLine.getBoolean("continueOnError", bl2);
        boolean bl4 = this.cmdLine.getBoolean("verbose", this.runner.getVerboseLogging());
        boolean bl5 = this.cmdLine.getBoolean("ignoreDropErrors", this.runner.getIgnoreDropErrors());
        boolean bl6 = this.cmdLine.getBoolean("printStatements", this.runner.getTraceStatements());
        boolean bl7 = this.cmdLine.getBoolean("showTiming", false);
        boolean bl8 = this.cmdLine.getBoolean("showProgress", true);
        this.dryRun = this.cmdLine.getBoolean(ARG_DRY_RUN);
        this.batchRunner = new BatchRunner();
        this.batchRunner.setBaseDir(this.getBaseDir());
        this.batchRunner.setConnection(this.currentConnection);
        this.batchRunner.setMessageLogger(this.messageLogger);
        this.batchRunner.setVerboseLogging(bl4);
        this.batchRunner.setIgnoreDropErrors(bl5);
        this.batchRunner.setAbortOnError(!bl3);
        this.batchRunner.setCheckEscapedQuotes(bl);
        this.batchRunner.setShowTiming(bl7);
        this.batchRunner.setParameterPrompter(this.prompter);
        this.batchRunner.setExecutionController(this.runner.getExecutionController());
        this.batchRunner.showResultSets(true);
        this.batchRunner.setShowProgress(bl8);
        this.batchRunner.setRowMonitor(this.rowMonitor);
        this.batchRunner.setShowStatementWithResult(bl6);
        this.batchRunner.setShowStatementSummary(false);
        this.batchRunner.setShowRowCounts(true);
        if (WbManager.getInstance().isConsoleMode()) {
            this.batchRunner.setMaxColumnDisplayLength(ConsoleSettings.getMaxColumnDataWidth());
        } else if (WbManager.getInstance().isGUIMode()) {
            this.batchRunner.setConsole(null);
        }
        LogMgr.logInfo(new CallerInfo(){}, "WbRunResult initialized. The result of the next statement will be run as a script");
        statementRunnerResult.setSuccess();
        String string3 = this.cmdLine.getValue(ARG_QUERY);
        if (StringUtil.isBlank(string3)) {
            this.runner.setConsumer(this);
            return statementRunnerResult;
        }
        try {
            this.currentStatement = this.currentConnection.createStatementForQuery();
            ResultSet resultSet = this.currentStatement.executeQuery(string3);
            this.processResults(statementRunnerResult, true, resultSet);
            if (this.isCancelled) {
                statementRunnerResult.addMessageByKey("MsgStatementCancelled");
            } else {
                this.consumeResult(statementRunnerResult);
            }
            return statementRunnerResult;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not run query", exception);
            statementRunnerResult.addErrorMessage(exception);
            return statementRunnerResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeResult(StatementRunnerResult statementRunnerResult) {
        Object object;
        if (this.batchRunner == null) {
            LogMgr.logError(new CallerInfo(){}, "consumeResult() called but batchRunner was not initialized", new Exception("Backtrace"));
            return;
        }
        if (statementRunnerResult == null) {
            return;
        }
        if (!statementRunnerResult.isSuccess()) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (statementRunnerResult.hasResultSets()) {
            try {
                arrayList = new ArrayList();
                for (ResultSet object2 : statementRunnerResult.getResultSets()) {
                    object = new DataStore(object2, true);
                    if (((DataStore)object).getRowCount() <= 0) continue;
                    arrayList.add(object);
                }
            }
            catch (SQLException sQLException) {
                statementRunnerResult.addErrorMessage(sQLException);
                return;
            }
            finally {
                statementRunnerResult.clearResultSets();
            }
        } else if (statementRunnerResult.hasDataStores()) {
            arrayList.addAll(statementRunnerResult.getDataStores());
            statementRunnerResult.getDataStores().clear();
        }
        try {
            for (DataStore dataStore : arrayList) {
                if (this.dryRun) {
                    statementRunnerResult.addDataStore(dataStore);
                    continue;
                }
                object = this.getScript(dataStore);
                this.runScript((String)object, statementRunnerResult);
                if (statementRunnerResult.isSuccess() || !this.batchRunner.getAbortOnError()) continue;
                break;
            }
        }
        finally {
            if (!this.dryRun) {
                for (DataStore dataStore : arrayList) {
                    dataStore.reset();
                }
            }
            this.runner.setConsumer(null);
            statementRunnerResult.setConsumed(true);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.batchRunner != null) {
            this.batchRunner.cancel();
        }
    }

    @Override
    public void done() {
        super.done();
        if (this.batchRunner != null) {
            this.batchRunner.done();
            this.batchRunner = null;
        }
    }

    @Override
    public boolean ignoreMaxRows() {
        return true;
    }

    private String getScript(DataStore dataStore) {
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(dataStore.getRowCount() * 100);
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string = dataStore.getValueAsString(i, 0);
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private void runScript(String string, StatementRunnerResult statementRunnerResult) {
        try {
            this.batchRunner.setScriptToRun(string);
            this.batchRunner.execute();
            if (this.batchRunner.isSuccess()) {
                statementRunnerResult.setSuccess();
            } else {
                statementRunnerResult.setFailure(this.batchRunner.getLastError());
            }
            List<DataStore> list = this.batchRunner.getQueryResults();
            for (DataStore dataStore : list) {
                statementRunnerResult.addDataStore(dataStore);
            }
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
            statementRunnerResult.setSuccess();
        }
        catch (Exception exception) {
            statementRunnerResult.addErrorMessage(exception);
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

