/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.sql.SQLException;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.PkMapping;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbSavePkMapping
extends SqlCommand {
    public static final String VERB = "WbSavePKMap";

    public WbSavePkMapping() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("file", ArgumentType.Filename);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        this.cmdLine.parse(this.getCommandLine(string));
        String string2 = this.cmdLine.getValue("file");
        if (string2 == null) {
            string2 = Settings.getInstance().getPKMappingFilename();
        } else {
            object = new WbFile(Settings.getInstance().getConfigDir());
            string2 = StringUtil.replace(string2, "%ConfigDir%", ((WbFile)object).getFullPath());
        }
        if (string2 == null) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessage(ResourceMgr.getString("ErrPkDefNoFile"));
            return statementRunnerResult;
        }
        PkMapping.getInstance().saveMapping(string2);
        object = ResourceMgr.getString("MsgPkMappingSaved");
        File file = new File(string2);
        object = StringUtil.replace((String)object, "%filename%", file.getAbsolutePath());
        statementRunnerResult.addMessage((CharSequence)object);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

