/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import workbench.db.DbObjectFinder;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.diff.SchemaDiff;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonDiffParameters;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.sql.wbcommands.WbXslt;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.XsltTransformer;

public class WbSchemaDiff
extends SqlCommand {
    public static final String VERB = "WbSchemaDiff";
    public static final String ARG_NAMESPACE = "namespace";
    public static final String ARG_INCLUDE_INDEX = "includeIndex";
    public static final String ARG_INCLUDE_FK = "includeForeignKeys";
    public static final String ARG_INCLUDE_PK = "includePrimaryKeys";
    public static final String ARG_INCLUDE_CONSTRAINTS = "includeConstraints";
    public static final String ARG_INCLUDE_VIEWS = "includeViews";
    public static final String ARG_DIFF_JDBC_TYPES = "useJdbcTypes";
    public static final String ARG_VIEWS_AS_TABLES = "viewAsTable";
    public static final String ARG_COMPARE_CHK_CONS_BY_NAME = "useConstraintNames";
    public static final String ARG_ADD_TYPES = "additionalTypes";
    private SchemaDiff diff;
    private CommonDiffParameters diffParams;

    public WbSchemaDiff() {
        this.cmdLine = new ArgumentParser();
        this.diffParams = new CommonDiffParameters(this.cmdLine, this.getBaseDir());
        this.cmdLine.addArgument(ARG_NAMESPACE);
        this.cmdLine.addArgument(ARG_INCLUDE_FK, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("includeSequences", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_PK, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_INDEX, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_CONSTRAINTS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_VIEWS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("includePartitions", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("includeProcedures", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("includeTableGrants", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("includeTriggers", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("writeFullSource", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_DIFF_JDBC_TYPES, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_VIEWS_AS_TABLES, ArgumentType.BoolArgument);
        WbXslt.addCommonXsltParameters(this.cmdLine);
        this.cmdLine.addArgument(ARG_COMPARE_CHK_CONS_BY_NAME, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_ADD_TYPES, ArgumentType.ListArgument);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Comparable<TableIdentifier> comparable;
        List<Object> list;
        Object object2;
        Object object3;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(this.messageLogger);
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.cmdLine.getArgumentCount() == 0 || this.cmdLine.getBoolean("help")) {
            statementRunnerResult.addErrorMessageByKey("ErrDiffWrongParameters");
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrDiffWrongParameters"));
            return statementRunnerResult;
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(7);
        }
        this.diffParams.setMonitor(this.rowMonitor);
        WbConnection wbConnection = this.diffParams.getTargetConnection(this.currentConnection, statementRunnerResult);
        if (!statementRunnerResult.isSuccess()) {
            return statementRunnerResult;
        }
        WbConnection wbConnection2 = this.diffParams.getSourceConnection(this.currentConnection, statementRunnerResult);
        if (wbConnection2 == null && wbConnection != null && wbConnection != this.currentConnection) {
            wbConnection.disconnect();
            return statementRunnerResult;
        }
        if (!statementRunnerResult.isSuccess()) {
            return statementRunnerResult;
        }
        if (this.isCancelled) {
            statementRunnerResult.addWarning(ResourceMgr.getString("MsgDiffCancelled"));
            return statementRunnerResult;
        }
        this.diff = new SchemaDiff(wbConnection2, wbConnection);
        this.diff.setMonitor(this.rowMonitor);
        this.diff.setIncludeForeignKeys(this.cmdLine.getBoolean(ARG_INCLUDE_FK, true));
        this.diff.setIncludeIndex(this.cmdLine.getBoolean(ARG_INCLUDE_INDEX, true));
        this.diff.setIncludePrimaryKeys(this.cmdLine.getBoolean(ARG_INCLUDE_PK, true));
        this.diff.setIncludeTableConstraints(this.cmdLine.getBoolean(ARG_INCLUDE_CONSTRAINTS, true));
        this.diff.setIncludeViews(this.cmdLine.getBoolean(ARG_INCLUDE_VIEWS, true));
        this.diff.setCompareJdbcTypes(this.cmdLine.getBoolean(ARG_DIFF_JDBC_TYPES, false));
        this.diff.setIncludeProcedures(this.cmdLine.getBoolean("includeProcedures", false));
        this.diff.setIncludeTableGrants(this.cmdLine.getBoolean("includeTableGrants", false));
        this.diff.setIncludeSequences(this.cmdLine.getBoolean("includeSequences", false));
        this.diff.setTreatViewAsTable(this.cmdLine.getBoolean(ARG_VIEWS_AS_TABLES, false));
        this.diff.setCompareConstraintsByName(this.cmdLine.getBoolean(ARG_COMPARE_CHK_CONS_BY_NAME, true));
        this.diff.setIncludeTriggers(this.cmdLine.getBoolean("includeTriggers", true));
        this.diff.setIncludePartitions(this.cmdLine.getBoolean("includePartitions", false));
        this.diff.setUseFullObjectSource(this.cmdLine.getBoolean("writeFullSource", false));
        List<String> list2 = this.cmdLine.getListValue(ARG_ADD_TYPES);
        this.diff.setAdditionalTypes(list2);
        String string2 = this.cmdLine.getValue("referenceTables");
        String string3 = this.cmdLine.getValue("targetTables");
        String string4 = this.cmdLine.getValue("excludeTables");
        if (string4 != null) {
            object3 = StringUtil.stringToList(string4, ",", true, true);
            this.diff.setExcludeTables((List<String>)object3);
        }
        object3 = this.cmdLine.getValue("referenceSchema");
        String string5 = this.cmdLine.getValue("targetSchema");
        if (string2 == null) {
            if (object3 == null && string5 == null) {
                if (wbConnection2 == wbConnection) {
                    statementRunnerResult.addErrorMessageByKey("ErrDiffSameConnectionNoTableSelection");
                    if (wbConnection.getId().startsWith("Wb-Diff")) {
                        try {
                            wbConnection.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (wbConnection2.getId().startsWith("Wb-Diff")) {
                        try {
                            wbConnection2.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return statementRunnerResult;
                }
                this.diff.compareAll();
            } else {
                this.diff.setSchemas((String)object3, string5);
            }
        } else if (string3 == null) {
            object2 = new SourceTableArgument(string2, wbConnection2);
            list = new ArrayList();
            for (TableIdentifier object4 : ((SourceTableArgument)object2).getTables()) {
                comparable = new DbObjectFinder(wbConnection2).findTable(object4, false);
                if (comparable == null) continue;
                list.add(comparable);
            }
            this.diff.setTables(list);
            this.diff.setSchemaNames((String)object3, string5);
        } else {
            object2 = StringUtil.stringToList(string2, ",", true, true);
            list = StringUtil.stringToList(string3, ",", true, true);
            if (object2.size() != list.size()) {
                statementRunnerResult.addMessageByKey("ErrDiffTableListNoMatch");
                statementRunnerResult.setFailure();
                return statementRunnerResult;
            }
            this.diff.setTableNames((List<String>)object2, list);
            this.diff.setSchemaNames((String)object3, string5);
        }
        if (this.isCancelled || this.diff.isCancelled()) {
            statementRunnerResult.addWarningByKey("MsgDiffCancelled");
            return statementRunnerResult;
        }
        object2 = null;
        boolean bl = false;
        WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
        try {
            if (wbFile == null) {
                object2 = new StringWriter(5000);
                bl = true;
            } else {
                String string6 = this.cmdLine.getValue("encoding", "UTF-8");
                string6 = EncodingUtil.cleanupEncoding(string6);
                this.diff.setEncoding(string6);
                object2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(wbFile), string6), 262144);
            }
            if (!this.diff.isCancelled()) {
                this.diff.writeXml((Writer)object2);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error writing output file", exception);
        }
        finally {
            FileUtil.closeQuietely((Closeable)object2);
            if (wbConnection2.getId().startsWith("Wb-Diff")) {
                wbConnection2.disconnect();
            }
            if (wbConnection.getId().startsWith("Wb-Diff")) {
                wbConnection.disconnect();
            }
        }
        if (this.diff.isCancelled()) {
            statementRunnerResult.addMessageByKey("MsgDiffCancelled");
        } else if (bl) {
            statementRunnerResult.addMessage(object2.toString());
        } else {
            String string7 = ResourceMgr.getString("MsgDiffFileWritten") + " " + wbFile.getFullPath();
            statementRunnerResult.addMessage(string7);
            comparable = this.findXsltFile(this.cmdLine.getValue("stylesheet"));
            WbFile wbFile2 = this.evaluateFileArgument(this.cmdLine.getValue("xsltOutput"));
            Map<String, String> map = WbXslt.getParameters(this.cmdLine);
            if (comparable != null && wbFile2 != null) {
                XsltTransformer xsltTransformer = new XsltTransformer();
                try {
                    xsltTransformer.setXsltBaseDir(this.getXsltBaseDir());
                    xsltTransformer.transform(wbFile, wbFile2, (File)comparable, map);
                    String string8 = xsltTransformer.getAllOutputs();
                    if (string8.length() != 0) {
                        statementRunnerResult.addMessage(string8);
                        statementRunnerResult.addMessageNewLine();
                    }
                    statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgXsltSuccessful", wbFile2));
                    statementRunnerResult.setSuccess();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LogMgr.logError(new CallerInfo(){}, "Stylesheet " + comparable + " not found!", fileNotFoundException);
                    statementRunnerResult.addErrorMessageByKey("ErrXsltNotFound", ((File)comparable).getAbsolutePath());
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error when transforming '" + wbFile.getFullPath() + "' to '" + wbFile2 + "' using " + comparable, exception);
                    statementRunnerResult.addErrorMessage(xsltTransformer.getAllOutputs(exception));
                }
            }
        }
        return statementRunnerResult;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.diff != null) {
            this.diff.cancel();
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

