/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.WbFile;

public class WbShowEncoding
extends SqlCommand {
    public static final String ARG_LIST = "list";
    public static final String ARG_FILE = "file";
    public static final String VERB = "WbShowEncoding";

    public WbShowEncoding() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_LIST, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_FILE, ArgumentType.Filename);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue(ARG_FILE));
        if (this.cmdLine.getBoolean(ARG_LIST)) {
            statementRunnerResult.addMessageByKey("MsgAvailableEncodings");
            statementRunnerResult.addMessageNewLine();
            for (String string2 : object = EncodingUtil.getEncodings()) {
                statementRunnerResult.addMessage(string2);
            }
            statementRunnerResult.addMessageNewLine();
        } else if (wbFile != null) {
            object = "File " + wbFile;
            if (wbFile.exists()) {
                String string3 = FileUtil.detectFileEncoding(wbFile);
                if (string3 != null && string3.toUpperCase().equals("UTF8")) {
                    string3 = string3 + " with BOM";
                }
                statementRunnerResult.addMessage((String)object + " has encoding: " + string3);
            } else {
                statementRunnerResult.addErrorMessage((String)object + " does not exist");
            }
        }
        object = ResourceMgr.getFormattedString("MsgDefaultEncoding", Settings.getInstance().getDefaultEncoding());
        statementRunnerResult.addMessage((CharSequence)object);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

