/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.sql.Statement;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;

public class WbStartBatch
extends SqlCommand {
    public static final String VERB = "WbStartBatch";
    private Statement batch;

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        if (!this.currentConnection.getMetadata().supportsBatchUpdates()) {
            this.batch = null;
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrJdbcBatchUpdateNotSupported");
        } else {
            this.batch = this.currentConnection.createStatement();
            statementRunnerResult.setSuccess();
            statementRunnerResult.addMessageByKey("MsgJdbcBatchProcessingStarted");
        }
        return statementRunnerResult;
    }

    public void addStatement(String string) throws SQLException {
        if (this.currentStatement == null) {
            throw new SQLException("Batch mode not supported");
        }
        this.batch.addBatch(string);
    }

    public StatementRunnerResult executeBatch() throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult("ExecuteBatch");
        if (this.batch == null) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrJdbcBatchUpdateNotSupported");
            return statementRunnerResult;
        }
        long l = 0L;
        statementRunnerResult.setSuccess();
        statementRunnerResult.addMessageByKey("MsgJdbcBatchProcessingEnded");
        int[] nArray = this.batch.executeBatch();
        if (nArray == null || nArray.length == 0) {
            statementRunnerResult.addMessageByKey("MsgJdbcBatchStatementNoInfo");
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                String string;
                if (nArray[i] != -3) {
                    string = ResourceMgr.getString("MsgJdbcBatchStatementFailed");
                    statementRunnerResult.addMessage(string.replace("%num%", Integer.toString(i)));
                    continue;
                }
                if (nArray[i] == -2) {
                    string = ResourceMgr.getString("MsgJdbcBatchStatementNoStatementInfo");
                    statementRunnerResult.addMessage(string.replace("%num%", Integer.toString(i)));
                    continue;
                }
                l += (long)nArray[i];
            }
            String string = ResourceMgr.getString("MsgJdbcBatchTotalRows") + " " + Long.toString(l);
            statementRunnerResult.addMessage(string);
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

