/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.db.DbSwitcher;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ExceptionUtil;

public class WbSwitchDB
extends SqlCommand {
    public static final String VERB = "WbSwitchDB";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        try {
            String string2 = this.getCommandLine(string);
            DbSwitcher dbSwitcher = DbSwitcher.Factory.createDatabaseSwitcher(this.currentConnection);
            if (dbSwitcher != null) {
                dbSwitcher.switchDatabase(this.currentConnection, string2);
                String string3 = ResourceMgr.getFormattedString("MsgCatalogChanged", ResourceMgr.getString("TxtDatabase"), string2);
                statementRunnerResult.addMessage(string3);
                statementRunnerResult.setSuccess();
            } else {
                statementRunnerResult.setFailure();
            }
        }
        catch (Exception exception) {
            statementRunnerResult.addMessageByKey("MsgExecuteError");
            statementRunnerResult.addErrorMessage(ExceptionUtil.getAllExceptions(exception).toString());
        }
        finally {
            this.done();
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

