/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.PlatformHelper;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbSysExec
extends SqlCommand {
    public static final String VERB = "WbSysExec";
    public static final String ARG_PROGRAM = "program";
    public static final String ARG_PRG_ARG = "argument";
    public static final String ARG_WORKING_DIR = "dir";
    public static final String ARG_DOCUMENT = "document";
    public static final String ARG_ENCODING = "encoding";
    public static final String ARG_ENV = "env";
    private Process task;

    public WbSysExec() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_PROGRAM);
        this.cmdLine.addArgument(ARG_WORKING_DIR);
        this.cmdLine.addArgument(ARG_DOCUMENT);
        this.cmdLine.addArgument(ARG_PRG_ARG, ArgumentType.Repeatable);
        this.cmdLine.addArgument(ARG_ENCODING);
        this.cmdLine.addArgument(ARG_ENV, ArgumentType.Repeatable);
        ConditionCheck.addParameters(this.cmdLine);
    }

    @Override
    public void cancel() throws SQLException {
        this.isCancelled = true;
        if (this.task != null) {
            this.task.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult;
        block24: {
            statementRunnerResult = this.createResult(string);
            String string2 = this.getCommandLine(string);
            if (StringUtil.isBlank(string2)) {
                statementRunnerResult.setFailure();
                statementRunnerResult.addMessageByKey("ErrExecNoParm");
                return statementRunnerResult;
            }
            this.cmdLine.parse(string2);
            if (this.displayHelp(statementRunnerResult)) {
                return statementRunnerResult;
            }
            if (!this.checkConditions(statementRunnerResult)) {
                return statementRunnerResult;
            }
            BufferedReader bufferedReader = null;
            BufferedReader bufferedReader2 = null;
            try {
                Object object;
                Object object2;
                Object object3;
                Object object5;
                String string3 = this.cmdLine.getValue(ARG_PROGRAM);
                String string4 = this.cmdLine.getValue(ARG_DOCUMENT);
                if (StringUtil.isNonBlank(string4) && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(new File(string4));
                        statementRunnerResult.setSuccess();
                    }
                    catch (IOException iOException) {
                        statementRunnerResult.setFailure();
                        statementRunnerResult.addMessage(iOException.getLocalizedMessage());
                    }
                    StatementRunnerResult statementRunnerResult2 = statementRunnerResult;
                    return statementRunnerResult2;
                }
                File file = new File(this.getBaseDir());
                List<String> list = new ArrayList<String>();
                List<String> list2 = this.cmdLine.getList(ARG_PRG_ARG);
                if (StringUtil.isNonBlank(string3)) {
                    if (string3.startsWith(".")) {
                        object5 = this.evaluateFileArgument(string3);
                        string3 = ((WbFile)object5).getFullPath();
                    }
                    list.add(string3);
                    for (String object42 : list2) {
                        object3 = StringUtil.stringToList(object42, " ", true, true, false, true);
                        list.addAll((Collection<String>)object3);
                    }
                } else {
                    object5 = StringUtil.stringToList(string2, " ", true, true, false, true);
                    list.addAll((Collection<String>)object5);
                }
                if (this.useShell((String)list.get(0))) {
                    list = this.getShell(list);
                }
                object5 = this.cmdLine.getValue(ARG_ENCODING, System.getProperty("file.encoding"));
                LogMgr.logDebug(new CallerInfo(){}, "Using encoding: " + (String)object5);
                ProcessBuilder processBuilder = new ProcessBuilder(list);
                object3 = this.cmdLine.getMapValue(ARG_ENV);
                if (CollectionUtil.isNonEmpty((Map)object3)) {
                    object2 = processBuilder.environment();
                    object2.putAll((Map<String, String>)object3);
                }
                if (StringUtil.isNonBlank((CharSequence)(object2 = this.cmdLine.getValue(ARG_WORKING_DIR)))) {
                    object = this.evaluateFileArgument((String)object2);
                    processBuilder.directory((File)object);
                } else {
                    processBuilder.directory(file);
                }
                LogMgr.logDebug(new CallerInfo(){}, "Running program: " + processBuilder.command());
                this.task = processBuilder.start();
                bufferedReader = new BufferedReader(new InputStreamReader(this.task.getInputStream(), (String)object5));
                bufferedReader2 = new BufferedReader(new InputStreamReader(this.task.getErrorStream(), (String)object5));
                object = bufferedReader.readLine();
                while (object != null) {
                    statementRunnerResult.addMessage((CharSequence)object);
                    object = bufferedReader.readLine();
                }
                String string5 = bufferedReader2.readLine();
                if (string5 != null) {
                    statementRunnerResult.setFailure();
                }
                while (string5 != null) {
                    statementRunnerResult.addErrorMessage(string5);
                    string5 = bufferedReader2.readLine();
                }
                this.task.waitFor();
                int n = this.task.exitValue();
                if (n != 0) {
                    statementRunnerResult.addMessage("Exit code: " + n);
                }
                FileUtil.closeQuietely(bufferedReader);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error calling external program", exception);
                statementRunnerResult.addMessage(ExceptionUtil.getDisplay(exception));
                statementRunnerResult.setFailure();
                break block24;
            }
            finally {
                FileUtil.closeQuietely(bufferedReader);
                FileUtil.closeQuietely(bufferedReader2);
                this.task = null;
            }
            FileUtil.closeQuietely(bufferedReader2);
            this.task = null;
        }
        return statementRunnerResult;
    }

    private List<String> getShell(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        String string = this.getOSID();
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 2);
        String string2 = StringUtil.getFirstWord(list.get(0)).toLowerCase();
        String string3 = System.getenv("SHELL");
        WbFile wbFile = this.evaluateFileArgument(string2);
        if ("windows".equals(string)) {
            if (!string2.startsWith("cmd")) {
                arrayList.add("cmd");
                arrayList.add("/c");
            }
            arrayList.addAll(list);
        } else if (wbFile != null && wbFile.canExecute()) {
            if (this.isShellScript(wbFile)) {
                arrayList.add(string3);
            }
            arrayList.add(StringUtil.listToString(list, ' '));
        } else if (!string2.startsWith(string3)) {
            arrayList.add(string3);
            arrayList.add("-c");
            arrayList.add(StringUtil.listToString(list, ' '));
        } else {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShellScript(WbFile wbFile) {
        boolean bl;
        int n;
        FileInputStream fileInputStream;
        block9: {
            if (wbFile == null) {
                return false;
            }
            if (!wbFile.exists()) {
                return false;
            }
            if (wbFile.length() < 3L) {
                return false;
            }
            fileInputStream = null;
            byte[] byArray = new byte[2];
            fileInputStream = new FileInputStream(wbFile);
            n = fileInputStream.read(byArray);
            if (n != 2) break block9;
            boolean bl2 = byArray[0] == 35 && byArray[1] == 33;
            FileUtil.closeQuietely(fileInputStream);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                n = 0;
                return n != 0;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                FileUtil.closeQuietely(fileInputStream);
            }
        }
        FileUtil.closeQuietely(fileInputStream);
        return bl;
    }

    private boolean useShell(String string) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        String string2 = this.getOSID();
        if (string2 == null) {
            return false;
        }
        string = StringUtil.getFirstWord(string);
        boolean bl = PlatformHelper.isWindows() || PlatformHelper.isMacOS();
        List<String> list = Settings.getInstance().getListProperty("workbench.exec." + string2 + ".useshell", false, "*");
        if (list.contains("*")) {
            return true;
        }
        for (String string3 : list) {
            if (StringUtil.compareStrings(string3, string, bl) != 0) continue;
            return true;
        }
        return false;
    }

    private String getOSID() {
        if (PlatformHelper.isWindows()) {
            return "windows";
        }
        if (PlatformHelper.isMacOS()) {
            return "macos";
        }
        if (PlatformHelper.isLinux()) {
            return "linux";
        }
        return null;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

