/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.awt.Desktop;
import java.sql.SQLException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.WbFile;

public class WbSysOpen
extends SqlCommand {
    public static final String VERB = "WbSysOpen";

    public WbSysOpen() {
        this.cmdLine = new ArgumentParser();
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        WbFile wbFile = this.evaluateFileArgument(this.getCommandLine(string));
        if (wbFile == null) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrSysOpenNoParm");
            return statementRunnerResult;
        }
        if (!wbFile.exists()) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrFileNotFound", wbFile.getFullPath());
            return statementRunnerResult;
        }
        try {
            Desktop.getDesktop().open(wbFile);
            statementRunnerResult.setSuccess();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not open file " + this.getCommandLine(string), exception);
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessage(exception.getLocalizedMessage());
        }
        return statementRunnerResult;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

