/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.IOException;
import java.sql.SQLException;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.TriggerReader;
import workbench.db.TriggerReaderFactory;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.WbFile;

public class WbTriggerSource
extends SqlCommand {
    public static final String VERB = "WbTriggerSource";
    public static final String ARG_TRIGGER_NAME = "trigger";
    public static final String ARG_INCLUDE_DEPS = "includeDependent";

    public WbTriggerSource() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("file");
        this.cmdLine.addArgument(ARG_TRIGGER_NAME);
        this.cmdLine.addArgument(ARG_INCLUDE_DEPS, ArgumentType.BoolArgument);
        CommonArgs.addEncodingParameter(this.cmdLine);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        boolean bl = true;
        String string3 = null;
        if (this.cmdLine.hasArguments()) {
            string3 = this.cmdLine.getValue(ARG_TRIGGER_NAME);
            bl = this.cmdLine.getBoolean(ARG_INCLUDE_DEPS, true);
        } else {
            string3 = string2;
        }
        TableIdentifier tableIdentifier = new TableIdentifier(string3, this.currentConnection);
        tableIdentifier.adjustCatalogAndSchema(this.currentConnection);
        TriggerReader triggerReader = TriggerReaderFactory.createReader(this.currentConnection);
        TriggerDefinition triggerDefinition = triggerReader.findTrigger(tableIdentifier.getCatalog(), tableIdentifier.getSchema(), tableIdentifier.getObjectName());
        String string4 = null;
        if (triggerDefinition != null) {
            string4 = triggerReader.getTriggerSource(triggerDefinition, bl);
        }
        if (string4 != null) {
            statementRunnerResult.setSuccess();
            String string5 = this.cmdLine.getValue("file");
            WbFile wbFile = this.evaluateFileArgument(string5);
            if (wbFile != null) {
                try {
                    String string6 = this.cmdLine.getValue("encoding", EncodingUtil.getDefaultEncoding());
                    FileUtil.writeString(wbFile, string4, string6, false);
                    statementRunnerResult.addMessageByKey("MsgScriptWritten", wbFile.getAbsolutePath());
                }
                catch (IOException iOException) {
                    statementRunnerResult.setFailure();
                    statementRunnerResult.addMessage(iOException.getLocalizedMessage());
                }
            } else {
                statementRunnerResult.addMessage(string4);
            }
        } else {
            statementRunnerResult.addMessageByKey("ErrTrgNotFound", tableIdentifier.getObjectExpression(this.currentConnection));
            statementRunnerResult.setFailure();
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

