/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.IOException;
import java.sql.SQLException;
import workbench.db.DbObjectFinder;
import workbench.db.DropType;
import workbench.db.ReaderFactory;
import workbench.db.TableIdentifier;
import workbench.db.ViewReader;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbViewSource
extends SqlCommand {
    public static final String VERB = "WbViewSource";
    public static final String ARG_VIEWNAME = "view";

    public WbViewSource() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_VIEWNAME);
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        CommonArgs.addEncodingParameter(this.cmdLine);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        String string3 = null;
        WbFile wbFile = null;
        String string4 = null;
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (this.cmdLine.hasArguments()) {
            string3 = this.cmdLine.getValue(ARG_VIEWNAME);
            wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
            string4 = this.cmdLine.getValue("encoding", EncodingUtil.getDefaultEncoding());
        } else {
            string3 = string2;
        }
        TableIdentifier tableIdentifier = new TableIdentifier(string3, this.currentConnection);
        TableIdentifier tableIdentifier2 = new DbObjectFinder(this.currentConnection).findObject(tableIdentifier);
        CharSequence charSequence = null;
        if (tableIdentifier2 != null) {
            ViewReader viewReader = ReaderFactory.createViewReader(this.currentConnection);
            charSequence = viewReader.getExtendedViewSource(tableIdentifier2, DropType.none);
        }
        if (StringUtil.isNonEmpty(charSequence)) {
            if (wbFile != null) {
                try {
                    FileUtil.writeString(wbFile, charSequence.toString(), string4, false);
                    statementRunnerResult.addMessageByKey("MsgScriptWritten", wbFile.getFullPath());
                    statementRunnerResult.setSuccess();
                }
                catch (IOException iOException) {
                    statementRunnerResult.addErrorMessage(iOException.getLocalizedMessage());
                }
            } else {
                statementRunnerResult.addMessage(charSequence);
                statementRunnerResult.setSuccess();
            }
        } else {
            statementRunnerResult.addErrorMessageByKey("ErrViewNotFound", tableIdentifier.getObjectExpression(this.currentConnection));
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

