/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.Map;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.SqlUtil;
import workbench.util.WbFile;
import workbench.util.XsltTransformer;

public class WbXslt
extends SqlCommand {
    public static final String VERB = "WbXslt";
    public static final String ARG_STYLESHEET = "stylesheet";
    public static final String ARG_OUTPUT = "xsltOutput";
    public static final String ARG_INPUT = "inputFile";
    public static final String ARG_PARAMETER = "xsltParameter";

    public WbXslt() {
        this.cmdLine = new ArgumentParser();
        WbXslt.addCommonXsltParameters(this.cmdLine);
        this.cmdLine.addArgument(ARG_INPUT, ArgumentType.Filename);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(this.messageLogger);
        String string2 = SqlUtil.stripVerb(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue(ARG_INPUT));
        WbFile wbFile2 = this.evaluateFileArgument(this.cmdLine.getValue(ARG_OUTPUT));
        WbFile wbFile3 = this.findXsltFile(this.cmdLine.getValue(ARG_STYLESHEET));
        if (!this.cmdLine.hasArguments()) {
            statementRunnerResult.addErrorMessageByKey("ErrXsltWrongParameter");
            return statementRunnerResult;
        }
        if (wbFile == null) {
            statementRunnerResult.addErrorMessageByKey("ErrXsltMissingInputFile");
            return statementRunnerResult;
        }
        if (!wbFile.exists()) {
            statementRunnerResult.addErrorMessageByKey("ErrFileNotFound", this.cmdLine.getValue(ARG_INPUT));
            return statementRunnerResult;
        }
        if (wbFile2 == null) {
            statementRunnerResult.addErrorMessageByKey("ErrXsltMissingOutputFile");
            return statementRunnerResult;
        }
        if (wbFile3 == null) {
            statementRunnerResult.addErrorMessageByKey("ErrXsltMissingStylesheet");
            return statementRunnerResult;
        }
        if (!wbFile3.exists()) {
            statementRunnerResult.addErrorMessageByKey("ErrFileNotFound", this.cmdLine.getValue(ARG_STYLESHEET));
            return statementRunnerResult;
        }
        Map<String, String> map = WbXslt.getParameters(this.cmdLine);
        XsltTransformer xsltTransformer = new XsltTransformer();
        try {
            xsltTransformer.setSaveSystemOutMessages(true);
            xsltTransformer.setXsltBaseDir(this.getXsltBaseDir());
            xsltTransformer.transform(wbFile, wbFile2, wbFile3, map);
            String string3 = xsltTransformer.getAllOutputs();
            if (string3.length() != 0) {
                statementRunnerResult.addMessage(string3);
                statementRunnerResult.addMessageNewLine();
            }
            WbFile wbFile4 = new WbFile(xsltTransformer.getXsltUsed());
            WbFile wbFile5 = new WbFile(wbFile3);
            if (wbFile4 != null && !wbFile5.equals(wbFile4)) {
                statementRunnerResult.addMessageByKey("MsgXsltUsed", wbFile4.getFullPath());
            }
            statementRunnerResult.addMessageByKey("MsgXsltSuccessful", wbFile2);
            statementRunnerResult.setSuccess();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when transforming '" + wbFile + "' to '" + wbFile2 + "' using " + wbFile3, exception);
            String string4 = xsltTransformer.getAllOutputs(exception);
            LogMgr.logError(new CallerInfo(){}, string4, null);
            statementRunnerResult.addErrorMessage(string4);
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    public static Map<String, String> getParameters(ArgumentParser argumentParser) {
        Map<String, String> map = argumentParser.getMapValue(ARG_PARAMETER);
        Map<String, String> map2 = argumentParser.getMapValue("xsltParameters");
        map.putAll(map2);
        return map;
    }

    public static void addCommonXsltParameters(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_STYLESHEET, ArgumentType.Filename);
        argumentParser.addArgument(ARG_PARAMETER, ArgumentType.Repeatable);
        argumentParser.addDeprecatedArgument("xsltParameters", ArgumentType.Repeatable);
        argumentParser.addArgument(ARG_OUTPUT, ArgumentType.Filename);
    }
}

