/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import workbench.db.ConnectionInfoBuilder;
import workbench.db.ConnectionMgr;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.MemoryWatcher;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbAbout
extends SqlCommand {
    public static final String VERB = "WbAbout";

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        statementRunnerResult.addMessage(ResourceMgr.getBuildInfo());
        statementRunnerResult.addMessage(ResourceMgr.getJavaInfo());
        statementRunnerResult.addMessage("Java Home: " + System.getProperty("java.home"));
        WbFile wbFile = Settings.getInstance().getConfigFile();
        String string2 = ResourceMgr.getFormattedString("LblSettingsLocation", wbFile.getFullPath());
        statementRunnerResult.addMessage(string2);
        string2 = ResourceMgr.getFormattedString("LblProfilesLocation", ConnectionMgr.getInstance().getProfilesPath());
        statementRunnerResult.addMessage(string2);
        wbFile = LogMgr.getLogfile();
        statementRunnerResult.addMessage("Logfile: " + (wbFile == null ? "" : wbFile.getFullPath()));
        long l = MemoryWatcher.getFreeMemory() / 0x100000L;
        long l2 = MemoryWatcher.MAX_MEMORY / 0x100000L;
        statementRunnerResult.addMessage(ResourceMgr.getString("LblMemory") + " " + l + "MB/" + l2 + "MB");
        String string3 = this.getConnectionInfo();
        if (string3 != null) {
            statementRunnerResult.addMessageNewLine();
            String string4 = ResourceMgr.getString("LblConnInfo");
            statementRunnerResult.addMessage(string4);
            String string5 = StringUtil.padRight("", string4.length(), '-');
            statementRunnerResult.addMessage(string5);
            statementRunnerResult.addMessage(string3);
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConnectionInfo() {
        if (this.currentConnection == null) {
            return null;
        }
        ConnectionInfoBuilder connectionInfoBuilder = new ConnectionInfoBuilder();
        boolean bl = this.currentConnection.isBusy();
        String string = null;
        try {
            this.currentConnection.setBusy(false);
            string = connectionInfoBuilder.getPlainTextDisplay(this.currentConnection, 0);
        }
        finally {
            this.currentConnection.setBusy(bl);
        }
        return string;
    }
}

