/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import java.util.List;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.MacroManager;
import workbench.sql.macros.MacroStorage;
import workbench.sql.wbcommands.CommonArgs;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbDefineMacro
extends SqlCommand {
    public static final String VERB = "WbDefineMacro";
    public static final String ARG_NAME = "name";
    public static final String ARG_TEXT = "text";
    public static final String ARG_GROUP = "group";
    public static final String ARG_EXPAND = "autoExpand";

    public WbDefineMacro() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_NAME);
        this.cmdLine.addArgument(ARG_TEXT);
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addArgument(ARG_GROUP);
        this.cmdLine.addArgument(ARG_EXPAND, ArgumentType.BoolSwitch);
        CommonArgs.addEncodingParameter(this.cmdLine);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (!this.cmdLine.hasArguments()) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrDefineMacro");
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, null);
            return statementRunnerResult;
        }
        String string2 = this.cmdLine.getValue(ARG_TEXT);
        WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
        String string3 = StringUtil.trimQuotes(this.cmdLine.getValue(ARG_GROUP));
        String string4 = this.cmdLine.getValue("encoding", null);
        String string5 = this.cmdLine.getValue(ARG_NAME);
        boolean bl = this.cmdLine.getBoolean(ARG_EXPAND);
        if (StringUtil.isBlank(string5)) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrMacroNameReq");
            return statementRunnerResult;
        }
        MacroStorage macroStorage = MacroManager.getInstance().getMacros(this.getMacroClientId());
        List<MacroGroup> list = macroStorage.getGroups();
        MacroGroup macroGroup = null;
        string2 = wbFile != null && wbFile.exists() ? FileUtil.readFile(wbFile, string4) : StringUtil.trimQuotes(string2);
        String string6 = null;
        MacroDefinition macroDefinition = macroStorage.getMacro(string5);
        if (macroDefinition == null) {
            macroDefinition = new MacroDefinition(string5, string2);
            string6 = ResourceMgr.getFormattedString("MsgMacroAdded", string5);
        } else {
            macroDefinition.setText(string2);
            string6 = ResourceMgr.getFormattedString("MsgMacroRedef", string5);
        }
        macroDefinition.setExpandWhileTyping(bl);
        if (StringUtil.isNonEmpty(string3)) {
            for (MacroGroup macroGroup2 : list) {
                if (!macroGroup2.getName().equalsIgnoreCase(string3)) continue;
                macroGroup = macroGroup2;
            }
        } else if (list.isEmpty()) {
            string3 = ResourceMgr.getString("LblDefGroup");
        } else {
            macroGroup = list.get(0);
        }
        if (macroGroup == null) {
            macroGroup = new MacroGroup(string3);
        }
        macroStorage.addMacro(macroGroup, macroDefinition);
        MacroManager.getInstance().save();
        statementRunnerResult.addMessage(string6);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

