/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroManager;
import workbench.sql.macros.MacroStorage;
import workbench.util.ArgumentParser;
import workbench.util.StringUtil;

public class WbDeleteMacro
extends SqlCommand {
    public static final String VERB = "WbDeleteMacro";
    public static final String ARG_NAME = "name";

    public WbDeleteMacro() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_NAME);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        String string3 = null;
        string3 = this.cmdLine.hasArguments() ? this.cmdLine.getValue(ARG_NAME) : StringUtil.trim(string2);
        if (StringUtil.isBlank(string3)) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrMacroNameReq");
            return statementRunnerResult;
        }
        MacroStorage macroStorage = MacroManager.getInstance().getMacros(this.getMacroClientId());
        MacroDefinition macroDefinition = macroStorage.getMacro(string3);
        if (macroDefinition != null) {
            macroStorage.removeMacro(macroDefinition);
            MacroManager.getInstance().save();
            statementRunnerResult.addMessageByKey("MsgMacroDeleted", macroDefinition.getName());
            statementRunnerResult.setSuccess();
        } else {
            statementRunnerResult.addMessageByKey("MsgMacroNotFound", string3);
            statementRunnerResult.setFailure();
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

