/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.gui.profiles.ProfileKey;
import workbench.interfaces.ExecutionController;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.StringUtil;

public class WbDeleteProfile
extends SqlCommand {
    public static final String VERB = "WbDeleteProfile";

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        if (StringUtil.isBlank(string2)) {
            statementRunnerResult.addMessageByKey("ErrNoProfile");
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        ProfileKey profileKey = new ProfileKey(string2);
        ConnectionProfile connectionProfile = ConnectionMgr.getInstance().getProfile(profileKey);
        if (connectionProfile != null) {
            profileKey = connectionProfile.getKey();
            boolean bl = true;
            ExecutionController executionController = this.runner.getExecutionController();
            if (executionController != null) {
                String string3 = ResourceMgr.getFormattedString("MsgConfirmProfDel", profileKey.toString());
                bl = executionController.confirmExecution(string3, null, null);
            }
            if (bl) {
                ConnectionMgr.getInstance().removeProfile(connectionProfile);
                ConnectionMgr.getInstance().saveProfiles();
                statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgProfileDeleted", profileKey.toString()));
            }
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

