/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import java.util.Set;
import workbench.RunMode;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class WbDisplay
extends SqlCommand {
    public static final String VERB = "WbDisplay";
    private final Set<String> tabularKeywords = CollectionUtil.caseInsensitiveSet("tab", "tabular", "row");
    private final Set<String> recordKeywords = CollectionUtil.caseInsensitiveSet("record", "form", "single");

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = StringUtil.trim(this.getCommandLine(string));
        if (StringUtil.isBlank(string2)) {
            RowDisplay rowDisplay = ConsoleSettings.getInstance().getRowDisplay();
            String string3 = "tab";
            if (rowDisplay == RowDisplay.Form) {
                string3 = "record";
            }
            statementRunnerResult.setSuccess();
            String string4 = ResourceMgr.getFormattedString("ErrDispWrongArgument", string3);
            statementRunnerResult.addMessage(string4);
        } else if (this.tabularKeywords.contains(string2)) {
            statementRunnerResult.setSuccess();
            ConsoleSettings.getInstance().setRowDisplay(RowDisplay.SingleLine);
            statementRunnerResult.addMessageByKey("MsgDispChangeRow");
        } else if (this.recordKeywords.contains(string2)) {
            ConsoleSettings.getInstance().setRowDisplay(RowDisplay.Form);
            statementRunnerResult.addMessageByKey("MsgDispChangeForm");
        }
        return statementRunnerResult;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public boolean isModeSupported(RunMode runMode) {
        return runMode != RunMode.GUI;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

