/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import java.util.List;
import workbench.db.ConnectionMgr;
import workbench.db.DbDriver;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class WbListDrivers
extends SqlCommand {
    public static final String VERB = "WbListDrivers";

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        List<DbDriver> list = ConnectionMgr.getInstance().getDrivers();
        String[] stringArray = new String[]{ResourceMgr.getString("LblDriver"), ResourceMgr.getString("LblDriverClass"), ResourceMgr.getString("LblDriverLibrary")};
        int[] nArray = new int[]{12, 12, 12};
        int[] nArray2 = new int[]{30, 40, 40};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        for (DbDriver dbDriver : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 0, (Object)dbDriver.getName());
            dataStore.setValue(n, 1, (Object)dbDriver.getDriverClass());
            dataStore.setValue(n, 2, (Object)StringUtil.listToString(dbDriver.getLibraryList(), System.getProperty("path.separator"), false));
        }
        dataStore.resetStatus();
        statementRunnerResult.addDataStore(dataStore);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

