/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import workbench.WbManager;
import workbench.console.WbConsole;
import workbench.console.WbConsoleFactory;
import workbench.db.ConnectionMgr;
import workbench.gui.WbSwingUtilities;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.GlobalPasswordManager;
import workbench.util.StringUtil;

public class WbRemoveMasterPwd
extends SqlCommand {
    public static final String VERB = "WbRemoveMasterPassword";

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        if (!Settings.getInstance().getUseMasterPassword()) {
            statementRunnerResult.addErrorMessageByKey("ErrNoMasterPwdSet");
            return statementRunnerResult;
        }
        if (!GlobalPasswordManager.getInstance().showPasswordPrompt(true)) {
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        boolean bl = false;
        String string2 = ResourceMgr.getString("MsgConfirmRemoveMasterPwd");
        if (WbManager.getInstance().isGUIMode()) {
            bl = WbSwingUtilities.getYesNo(WbManager.getInstance().getCurrentWindow(), string2);
        } else {
            WbConsole wbConsole = WbConsoleFactory.getConsole();
            String string3 = ResourceMgr.getString("MsgConfirmYes").toLowerCase();
            String string4 = ResourceMgr.getString("MsgConfirmNo").toLowerCase();
            string2 = string2 + " (" + string3 + "/" + string4 + "): ";
            String string5 = wbConsole.readLineWithoutHistory(string2);
            bl = string3.equalsIgnoreCase(StringUtil.trim(string5));
        }
        if (bl) {
            GlobalPasswordManager.getInstance().applyNewPassword(null);
            Settings.getInstance().saveSettings(false);
            ConnectionMgr.getInstance().saveProfiles();
            statementRunnerResult.addMessageByKey("MsgMasterPwdRemoved");
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

