/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import java.util.List;
import workbench.WbManager;
import workbench.console.ConsoleSettings;
import workbench.resource.Settings;
import workbench.sql.BatchRunner;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbRun
extends SqlCommand {
    public static final String VERB = "WbRun";

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        statementRunnerResult.setSuccess();
        String string2 = this.getCommandLine(string);
        if (StringUtil.isBlank(string2)) {
            statementRunnerResult.addErrorMessageByKey("ErrFileNameRqd");
            return statementRunnerResult;
        }
        WbFile wbFile = this.evaluateFileArgument(string2);
        if (StringUtil.isEmptyString(wbFile.getExtension())) {
            wbFile = new WbFile(wbFile.getFullPath() + ".sql");
        }
        if (StringUtil.isEmptyString(string2) || !wbFile.exists()) {
            statementRunnerResult.addErrorMessageByKey("ErrFileNotFound", wbFile.getFullPath());
            return statementRunnerResult;
        }
        boolean bl = Settings.getInstance().useNonStandardQuoteEscaping(this.currentConnection);
        boolean bl2 = this.currentConnection == null ? false : this.currentConnection.getProfile().getIgnoreDropErrors();
        String string3 = Settings.getInstance().getDefaultEncoding();
        try {
            BatchRunner batchRunner = new BatchRunner(wbFile.getCanonicalPath());
            String string4 = wbFile.getCanonicalFile().getParent();
            batchRunner.setBaseDir(string4);
            batchRunner.setConnection(this.currentConnection);
            batchRunner.setMessageLogger(this.messageLogger);
            batchRunner.setRowMonitor(null);
            batchRunner.setVerboseLogging(false);
            batchRunner.setIgnoreDropErrors(bl2);
            batchRunner.setAbortOnError(true);
            batchRunner.setCheckEscapedQuotes(bl);
            batchRunner.setShowTiming(false);
            batchRunner.setEncoding(string3);
            batchRunner.setParameterPrompter(this.prompter);
            batchRunner.setExecutionController(this.runner.getExecutionController());
            batchRunner.setOptimizeColWidths(true);
            batchRunner.showResultSets(true);
            if (WbManager.getInstance().isConsoleMode()) {
                batchRunner.setMaxColumnDisplayLength(ConsoleSettings.getMaxColumnDataWidth());
            }
            batchRunner.setShowProgress(false);
            batchRunner.setShowStatementWithResult(this.runner.getTraceStatements());
            batchRunner.setShowStatementSummary(this.runner.getVerboseLogging());
            batchRunner.setShowRowCounts(true);
            if (WbManager.getInstance().isGUIMode()) {
                batchRunner.setConsole(null);
            }
            batchRunner.execute();
            if (batchRunner.isSuccess()) {
                statementRunnerResult.setSuccess();
            } else {
                statementRunnerResult.setFailure(batchRunner.getLastError());
            }
            List<DataStore> list = batchRunner.getQueryResults();
            for (DataStore dataStore : list) {
                statementRunnerResult.addDataStore(dataStore);
            }
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
        }
        catch (Exception exception) {
            statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(exception));
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

