/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.awt.Frame;
import java.sql.SQLException;
import javax.swing.JFrame;
import workbench.WbManager;
import workbench.console.WbConsole;
import workbench.console.WbConsoleFactory;
import workbench.db.ConnectionMgr;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.MasterPasswordDialog;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.GlobalPasswordManager;
import workbench.util.StringUtil;

public class WbSetMasterPwd
extends SqlCommand {
    public static final String VERB = "WbSetMasterPassword";

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        if (!GlobalPasswordManager.getInstance().showPasswordPrompt(true)) {
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        String string2 = null;
        if (WbManager.getInstance().isGUIMode()) {
            JFrame jFrame = WbManager.getInstance().getCurrentWindow();
            MasterPasswordDialog masterPasswordDialog = new MasterPasswordDialog((Frame)jFrame, false);
            Settings.getInstance().restoreWindowSize(masterPasswordDialog);
            WbSwingUtilities.center(masterPasswordDialog, jFrame);
            masterPasswordDialog.setVisible(true);
            if (!masterPasswordDialog.wasCancelled() && masterPasswordDialog.getMasterPassword() != null) {
                string2 = masterPasswordDialog.getMasterPassword();
            }
        } else {
            string2 = this.getPasswordFromConsole(statementRunnerResult);
        }
        if (string2 != null && statementRunnerResult.isSuccess()) {
            GlobalPasswordManager.getInstance().applyNewPassword(string2);
            Settings.getInstance().saveSettings(false);
            ConnectionMgr.getInstance().saveProfiles();
            statementRunnerResult.addMessageByKey("MsgMasterPwdSet");
        }
        return statementRunnerResult;
    }

    private String getPasswordFromConsole(StatementRunnerResult statementRunnerResult) {
        String string = ResourceMgr.getString("LblMasterPwdWarn");
        string = string.replace("<br>", "\n");
        string = string.replace("<html>", "");
        string = string.replace("</html>", "");
        System.out.println(string);
        System.out.println("");
        WbConsole wbConsole = WbConsoleFactory.getConsole();
        String string2 = wbConsole.readPassword(ResourceMgr.getString("LblNewPwd") + ": ");
        if (StringUtil.isEmptyString(string2)) {
            statementRunnerResult.addErrorMessageByKey("MsgNoPwd");
            return null;
        }
        String string3 = wbConsole.readPassword(ResourceMgr.getString("LblPwdRepeat") + ": ");
        if (!StringUtil.equalString(string2, string3)) {
            statementRunnerResult.addErrorMessageByKey("MsgPwdNoMatch");
            return null;
        }
        statementRunnerResult.setSuccess();
        return string2;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

