/*
 * Decompiled with CFR 0.152.
 */
package workbench.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.ssh.SshHostConfig;
import workbench.util.WbFile;

public class PortForwarder
implements UserInfo {
    public static final int DEFAULT_SSH_PORT = 22;
    private String sshHost;
    private String sshUser;
    private String password;
    private String passphrase;
    private String privateKeyFile;
    private Session session;
    private int localPort;
    private boolean tryAgent;

    public PortForwarder(SshHostConfig sshHostConfig) {
        this.sshHost = sshHostConfig.getHostname();
        this.sshUser = sshHostConfig.getUsername();
        this.password = sshHostConfig.getDecryptedPassword();
        this.tryAgent = sshHostConfig.getTryAgent();
        this.setPrivateKeyFile(sshHostConfig.getPrivateKeyFile());
    }

    private void setPrivateKeyFile(String string) {
        File file;
        this.privateKeyFile = null;
        if (string != null && (file = new File(string)).exists()) {
            this.privateKeyFile = file.getAbsolutePath();
        }
    }

    public int startFowarding(String string, int n) throws JSchException {
        return this.startForwarding(string, n, 0, 22);
    }

    public synchronized int startForwarding(String string, int n, int n2, int n3) throws JSchException {
        boolean bl;
        Properties properties = new Properties();
        properties.put("StrictHostKeyChecking", "no");
        JSch jSch = new JSch();
        CallerInfo callerInfo = new CallerInfo(){};
        long l = System.currentTimeMillis();
        LogMgr.logDebug(callerInfo, "Connecting to SSH host: " + this.sshHost + ":" + n3 + " using username: " + this.sshUser);
        boolean bl2 = bl = this.tryAgent && this.tryAgent(jSch);
        if (!bl && this.privateKeyFile != null) {
            jSch.addIdentity(this.privateKeyFile, this.password);
        }
        this.session = jSch.getSession(this.sshUser, this.sshHost, n3);
        this.session.setUserInfo(this);
        if (!bl && this.privateKeyFile == null) {
            properties.put("PreferredAuthentications", "password,keyboard-interactive");
            this.session.setPassword(this.password);
        }
        this.session.setConfig(properties);
        this.session.connect();
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logInfo(callerInfo, "Connected to SSH host: " + this.sshHost + ":" + n3 + " using username: " + this.sshUser + " (" + l2 + "ms)");
        if (n2 < 0) {
            n2 = 0;
        }
        this.localPort = this.session.setPortForwardingL(n2, string, n);
        LogMgr.logInfo(callerInfo, "Port forwarding established: localhost:" + this.localPort + " -> " + string + ":" + n + " through host " + this.sshHost);
        return this.localPort;
    }

    private boolean tryAgent(JSch jSch) {
        try {
            Connector connector = ConnectorFactory.getDefault().createConnector();
            if (connector == null) {
                return false;
            }
            RemoteIdentityRepository remoteIdentityRepository = new RemoteIdentityRepository(connector);
            Vector vector = remoteIdentityRepository.getIdentities();
            if (vector.size() > 0) {
                LogMgr.logInfo(new CallerInfo(){}, "Using " + vector.size() + " identities from agent: " + connector.getName());
                jSch.setIdentityRepository(remoteIdentityRepository);
                return true;
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when accessing agent", throwable);
        }
        return false;
    }

    public String toString() {
        return this.sshUser + "@" + this.sshHost + " localport: " + this.localPort;
    }

    public synchronized boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public synchronized void close() {
        if (this.isConnected()) {
            LogMgr.logDebug(new CallerInfo(){}, "Disconnecting ssh session to host: " + this.session.getHost());
            this.session.disconnect();
        }
        this.session = null;
        this.localPort = -1;
    }

    @Override
    public String getPassphrase() {
        LogMgr.logDebug(new CallerInfo(){}, "UserInfo.getPassphrase() called.");
        return this.passphrase;
    }

    @Override
    public String getPassword() {
        LogMgr.logDebug(new CallerInfo(){}, "UserInfo.getPassword() called.");
        return this.password;
    }

    @Override
    public boolean promptPassword(String string) {
        LogMgr.logDebug(new CallerInfo(){}, "UserInfo.promptPassword() called with message: " + string);
        String string2 = ResourceMgr.getString("MsgInputSshPwd");
        String string3 = string.replace("Password for ", "");
        String string4 = ResourceMgr.getFormattedString("MsgInputPwd", string3);
        String string5 = WbSwingUtilities.passwordPrompt(WbManager.getInstance().getCurrentWindow(), string2, string4);
        if (string5 == null) {
            return false;
        }
        this.password = string5;
        return true;
    }

    @Override
    public boolean promptPassphrase(String string) {
        LogMgr.logDebug(new CallerInfo(){}, "UserInfo.promptPassphrase() called with message: " + string);
        String string2 = ResourceMgr.getString("MsgInputSshPassPhrase");
        WbFile wbFile = new WbFile(this.privateKeyFile);
        String string3 = ResourceMgr.getFormattedString("MsgInputPwd", wbFile.getFileName());
        String string4 = WbSwingUtilities.passwordPrompt(WbManager.getInstance().getCurrentWindow(), string2, string3);
        if (string4 == null) {
            return false;
        }
        this.passphrase = string4;
        return true;
    }

    @Override
    public boolean promptYesNo(String string) {
        LogMgr.logDebug(new CallerInfo(){}, "JSch.UserInfo.promptYesNo() called with message: " + string);
        string = "<html>" + string.replaceAll("((\r\n)|(\n\r)|\r|\n)", "<br>") + "</html>";
        boolean bl = WbSwingUtilities.getYesNo(WbManager.getInstance().getCurrentWindow(), string);
        return bl;
    }

    @Override
    public void showMessage(String string) {
        LogMgr.logDebug(new CallerInfo(){}, "JSch.UserInfo.showMessage() called with message: " + string);
        string = "<html>" + string.replaceAll("((\r\n)|(\n\r)|\r|\n)", "<br>") + "</html>";
        WbSwingUtilities.showMessage(WbManager.getInstance().getCurrentWindow(), string);
    }
}

