/*
 * Decompiled with CFR 0.152.
 */
package workbench.ssh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.ssh.SshHostConfig;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbProperties;

public class SshConfigMgr {
    private static final String PREFIX = "config";
    private static final String CONFIG_NAME = ".name";
    private final List<SshHostConfig> globalConfigs = new ArrayList<SshHostConfig>();
    private boolean loaded = false;
    private boolean changed = false;
    private final WbFile configFile;

    public static final SshConfigMgr getDefaultInstance() {
        return InstanceHolder.INSTANCE;
    }

    public SshConfigMgr(WbFile wbFile) {
        this.configFile = wbFile;
    }

    public List<SshHostConfig> getGlobalConfigs() {
        this.ensureLoaded();
        return Collections.unmodifiableList(this.globalConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGlobalConfig() {
        if (!this.loaded) {
            return;
        }
        WbProperties wbProperties = new WbProperties(0);
        Object object = PREFIX;
        synchronized (PREFIX) {
            for (int i = 0; i < this.globalConfigs.size(); ++i) {
                String string = StringUtil.formatInt(i + 1, 4).toString();
                this.writeConfig(this.globalConfigs.get(i), wbProperties, string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object = new CallerInfo(){};
            try {
                if (this.globalConfigs.isEmpty() && this.changed) {
                    this.configFile.delete();
                    LogMgr.logInfo((CallerInfo)object, "Global SSH host configuration file " + this.configFile.getFullPath() + " removed.");
                } else {
                    wbProperties.saveToFile(this.configFile);
                    LogMgr.logInfo((CallerInfo)object, "Global SSH host configurations saved to: " + this.configFile.getFullPath());
                }
                this.changed = false;
            }
            catch (Exception exception) {
                LogMgr.logError((CallerInfo)object, "Could not save global SSH host configurations", exception);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigs(List<SshHostConfig> list) {
        String string = PREFIX;
        synchronized (PREFIX) {
            this.globalConfigs.clear();
            this.globalConfigs.addAll(list);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.changed = true;
            this.loaded = true;
            return;
        }
    }

    public void replaceConfig(SshHostConfig sshHostConfig) {
        if (sshHostConfig == null) {
            return;
        }
        int n = this.findConfig(sshHostConfig);
        if (n > -1) {
            this.globalConfigs.set(n, sshHostConfig);
        } else {
            this.globalConfigs.add(sshHostConfig);
        }
        this.changed = true;
    }

    public SshHostConfig getHostConfig(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        this.ensureLoaded();
        int n = this.findConfig(string);
        if (n > -1) {
            return this.globalConfigs.get(n);
        }
        return null;
    }

    private int findConfig(SshHostConfig sshHostConfig) {
        if (sshHostConfig == null) {
            return -1;
        }
        return this.findConfig(sshHostConfig.getConfigName());
    }

    private int findConfig(String string) {
        if (StringUtil.isBlank(string)) {
            return -1;
        }
        for (int i = 0; i < this.globalConfigs.size(); ++i) {
            if (!StringUtil.equalStringIgnoreCase(string, this.globalConfigs.get(i).getConfigName())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded() {
        String string = PREFIX;
        synchronized (PREFIX) {
            if (!this.loaded) {
                this.loadConfigs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void writeConfig(SshHostConfig sshHostConfig, WbProperties wbProperties, String string) {
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        wbProperties.setProperty(PREFIX + string + ".ssh.host", sshHostConfig.getHostname());
        wbProperties.setProperty(PREFIX + string + ".ssh.user", sshHostConfig.getUsername());
        wbProperties.setProperty(PREFIX + string + ".ssh.keyfile", sshHostConfig.getPrivateKeyFile());
        wbProperties.setProperty(PREFIX + string + ".ssh.pwd", sshHostConfig.getPassword());
        wbProperties.setProperty(PREFIX + string + ".ssh.port", sshHostConfig.getSshPort());
        wbProperties.setProperty(PREFIX + string + CONFIG_NAME, sshHostConfig.getConfigName());
        if (sshHostConfig.getTryAgent()) {
            wbProperties.setProperty(PREFIX + string + ".ssh.try.agent", sshHostConfig.getTryAgent());
        }
    }

    private SshHostConfig readConfig(WbProperties wbProperties, String string) {
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        String string2 = wbProperties.getProperty(PREFIX + string + ".ssh.host", null);
        String string3 = wbProperties.getProperty(PREFIX + string + ".ssh.user", null);
        String string4 = wbProperties.getProperty(PREFIX + string + ".ssh.keyfile", null);
        String string5 = wbProperties.getProperty(PREFIX + string + ".ssh.pwd", null);
        String string6 = wbProperties.getProperty(PREFIX + string + CONFIG_NAME, null);
        int n = wbProperties.getIntProperty(PREFIX + string + ".ssh.port", 22);
        boolean bl = wbProperties.getBoolProperty(PREFIX + string + ".ssh.try.agent", false);
        if (string6 != null && string2 != null && string3 != null) {
            SshHostConfig sshHostConfig = new SshHostConfig(string6);
            sshHostConfig.setPassword(string5);
            sshHostConfig.setHostname(string2);
            sshHostConfig.setUsername(string3);
            sshHostConfig.setPrivateKeyFile(string4);
            sshHostConfig.setTryAgent(bl);
            sshHostConfig.setSshPort(n);
            return sshHostConfig;
        }
        return null;
    }

    private Set<String> getConfigKeys(WbProperties wbProperties) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Set<String> set = wbProperties.getKeys();
        for (String string : set) {
            String[] stringArray = string.split("\\.");
            if (stringArray.length <= 2) continue;
            treeSet.add(stringArray[1]);
        }
        return treeSet;
    }

    private void loadConfigs() {
        if (this.configFile == null || !this.configFile.exists()) {
            return;
        }
        this.globalConfigs.clear();
        try {
            WbProperties wbProperties = new WbProperties(0);
            wbProperties.loadTextFile(this.configFile);
            Set<String> set = this.getConfigKeys(wbProperties);
            for (String string : set) {
                SshHostConfig sshHostConfig3 = this.readConfig(wbProperties, string);
                if (sshHostConfig3 == null) continue;
                this.globalConfigs.add(sshHostConfig3);
            }
            Collections.sort(this.globalConfigs, (sshHostConfig, sshHostConfig2) -> StringUtil.compareStrings(sshHostConfig.getConfigName(), sshHostConfig2.getConfigName(), true));
            this.loaded = true;
            this.changed = false;
            LogMgr.logInfo(new CallerInfo(){}, "Loaded global SSH host configurations from " + this.configFile.getFullPath());
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not load global SSH host configurations", exception);
            this.loaded = false;
        }
    }

    private static class InstanceHolder {
        protected static final SshConfigMgr INSTANCE = new SshConfigMgr(Settings.getInstance().getGlogalSshConfigFile());

        private InstanceHolder() {
        }
    }
}

