/*
 * Decompiled with CFR 0.152.
 */
package workbench.ssh;

import java.io.Serializable;
import java.util.Objects;
import workbench.db.PasswordTrimType;
import workbench.resource.Settings;
import workbench.util.GlobalPasswordManager;
import workbench.util.StringUtil;

public class SshHostConfig
implements Serializable {
    private String sshHost;
    private String password;
    private String username;
    private String privateKeyFile;
    private String configName;
    private String temporaryPassword;
    private int sshPort = 22;
    private boolean tryAgent;

    public SshHostConfig() {
    }

    public SshHostConfig(String string) {
        this.configName = StringUtil.trimToNull(string);
    }

    public boolean isGlobalConfig() {
        return this.configName != null;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int n) {
        if (n > 0 && n != this.sshPort) {
            this.sshPort = n;
        }
    }

    public boolean getTryAgent() {
        return this.tryAgent;
    }

    public void setTryAgent(boolean bl) {
        this.tryAgent = bl;
    }

    public void setTemporaryPassword(String string) {
        this.temporaryPassword = string;
    }

    public void clearTemporaryPassword() {
        this.temporaryPassword = null;
    }

    public boolean hasTemporaryPassword() {
        return this.temporaryPassword != null;
    }

    public String getHostname() {
        return this.sshHost;
    }

    public void setHostname(String string) {
        this.sshHost = string;
    }

    public void setEncryptedPassword(String string) {
        this.password = string;
    }

    public String getDecryptedPassword() {
        if (this.temporaryPassword != null) {
            return this.temporaryPassword;
        }
        return this.decryptPassword(this.password);
    }

    private String decryptPassword(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("$@wb@$")) {
            return GlobalPasswordManager.getInstance().decrypt(string.substring("$@wb@$".length()));
        }
        return string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        if (string != null) {
            PasswordTrimType passwordTrimType = Settings.getInstance().getPassworTrimType();
            if (passwordTrimType == PasswordTrimType.always) {
                string = string.trim();
            } else if (passwordTrimType == PasswordTrimType.blankOnly && StringUtil.isBlank(string)) {
                string = "";
            }
        }
        if (StringUtil.isNonEmpty(string)) {
            if (Settings.getInstance().getUseMasterPassword()) {
                if (!this.isEncrypted(string)) {
                    string = "$@wb@$" + GlobalPasswordManager.getInstance().encrypt(string);
                }
            } else if (this.isEncrypted(string)) {
                string = this.decryptPassword(string);
            }
        }
        this.password = string;
    }

    private boolean isEncrypted(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("$@wb@$");
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String string) {
        this.privateKeyFile = string;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String string) {
        this.configName = StringUtil.trimToNull(string);
    }

    public boolean isValid() {
        return this.sshHost != null && this.username != null;
    }

    public SshHostConfig createCopy() {
        SshHostConfig sshHostConfig = new SshHostConfig();
        sshHostConfig.sshHost = this.sshHost;
        sshHostConfig.password = this.password;
        sshHostConfig.temporaryPassword = this.temporaryPassword;
        sshHostConfig.privateKeyFile = this.privateKeyFile;
        sshHostConfig.sshPort = this.sshPort;
        sshHostConfig.tryAgent = this.tryAgent;
        sshHostConfig.username = this.username;
        sshHostConfig.configName = this.configName;
        return sshHostConfig;
    }

    public int hashCode() {
        int n = 3;
        n = 37 * n + Objects.hashCode(this.sshHost);
        n = 37 * n + Objects.hashCode(this.username);
        n = 37 * n + Objects.hashCode(this.privateKeyFile);
        n = 37 * n + Objects.hashCode(this.configName);
        n = 37 * n + this.sshPort;
        n = 37 * n + Boolean.hashCode(this.tryAgent);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SshHostConfig sshHostConfig = (SshHostConfig)object;
        if (this.sshPort != sshHostConfig.sshPort) {
            return false;
        }
        if (this.tryAgent != sshHostConfig.tryAgent) {
            return false;
        }
        if (!Objects.equals(this.sshHost, sshHostConfig.sshHost)) {
            return false;
        }
        if (!Objects.equals(this.username, sshHostConfig.username)) {
            return false;
        }
        if (!Objects.equals(this.privateKeyFile, sshHostConfig.privateKeyFile)) {
            return false;
        }
        return Objects.equals(this.configName, sshHostConfig.configName);
    }

    public String getInfoString() {
        if (this.sshPort == 0 || this.sshPort == 22) {
            return this.sshHost;
        }
        this.sshHost = this.sshHost + ":" + this.sshPort;
        return this.sshHost;
    }

    public String toString() {
        return this.configName;
    }
}

